#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=158480 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (134999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 15:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 17:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 17:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 17:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:44:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:44:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:44:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-18 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-18 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-18 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135508, 'Database Backup [database_backup_2024-11-19-00-00-05-v3-1-6.zip]', '2024-11-19 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 10:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 10:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 10:55:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:00:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:00:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:00:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:11:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:11:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:11:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:27:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:27:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:27:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:27:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:27:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:27:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:33:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:33:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:33:22', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (135999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:35:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:47:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:03:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 18:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 18:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 18:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 18:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 18:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 18:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 20:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 23:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 23:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-19 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-19 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-19 23:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 00:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136313, 'Database Backup [database_backup_2024-11-20-00-00-03-v3-1-6.zip]', '2024-11-20 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 03:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 03:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136488, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2024-11-20 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 05:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 05:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 05:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 06:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 07:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 08:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 08:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 08:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 08:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 09:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 09:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 09:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 09:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 11:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 13:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 13:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 14:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 14:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 14:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 14:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 16:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 18:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 18:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 18:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 18:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 19:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 19:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (136999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137014, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-11-20 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137015, 'Email Sent To [Email: extreme_effect_graphix@yahoo.com, Template: Invoice Overdue Notice]', '2024-11-20 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 21:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 21:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 22:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 22:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 22:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 22:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 22:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 22:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 22:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 22:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 22:29:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 22:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 22:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 22:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 22:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 23:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 23:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 23:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 23:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-20 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-20 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-20 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137118, 'Database Backup [database_backup_2024-11-21-00-00-05-v3-1-6.zip]', '2024-11-21 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 00:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 00:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 00:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 01:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 01:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 02:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 02:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 02:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 02:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 02:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 02:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 02:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 03:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 03:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:13:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 18:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-21 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-21 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-21 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137914, 'Database Backup [database_backup_2024-11-22-00-02-02-v3-1-6.zip]', '2024-11-22 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (137999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 02:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 05:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 07:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 14:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 16:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 17:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:52:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 22:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-22 23:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-22 23:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-22 23:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138701, 'Database Backup [database_backup_2024-11-23-00-04-02-v3-1-6.zip]', '2024-11-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:32:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 01:58:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 01:58:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 01:58:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:22:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:22:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:22:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 03:56:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 03:56:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 03:56:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (138999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 10:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 11:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:33:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-11-23 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-11-23 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (139280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-11-23 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `descrip