#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=263537 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 08:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 20:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238731, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-27 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-27 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-27 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238837, 'Database Backup [database_backup_2025-03-28-00-00-06-v3-1-6.zip]', '2025-03-28 00:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (238999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 06:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 09:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 13:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 16:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 16:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 16:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 18:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 19:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239618, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:16ba:a258:a264:edd8]', '2025-03-28 22:51:19', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-28 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-28 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-28 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239658, 'Database Backup [database_backup_2025-03-29-00-00-04-v3-1-6.zip]', '2025-03-29 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 05:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 05:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 05:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (239999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 11:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 11:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 11:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 18:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240400, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-29 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240401, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-03-29 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 21:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-29 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-29 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-29 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240522, 'Database Backup [database_backup_2025-03-30-00-04-02-v3-1-6.zip]', '2025-03-30 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 00:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 01:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 02:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (240999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241210, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-03-30 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 21:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-30 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-30 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-30 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241322, 'Database Backup [database_backup_2025-03-31-00-03-02-v3-1-6.zip]', '2025-03-31 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 01:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 02:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 04:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 04:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 04:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (241999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242028, 'Email Sent To [Email: shaykar02@hotmail.com, Template: Invoice Due Notice]', '2025-03-31 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242029, 'Email Sent To [Email: na@saylesstt.com, Template: Invoice Due Notice]', '2025-03-31 21:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-03-31 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-03-31 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-03-31 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242129, 'Database Backup [database_backup_2025-04-01-00-02-04-v3-1-6.zip]', '2025-04-01 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 01:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:28:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:39:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:39:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 07:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-04-01 14:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-04-01 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (242599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-04-01 14:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `descripti