#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=109997 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:39:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 12:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 14:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 15:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 16:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:03:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:47:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 18:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86648, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.203]', '2024-09-18 19:31:58', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 19:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86703, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-09-18 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:02:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 21:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-18 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-18 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-18 23:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86809, 'Database Backup [database_backup_2024-09-19-00-00-04-v3-1-6.zip]', '2024-09-19 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 01:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 01:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 01:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 03:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 03:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 03:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (86999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 07:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 07:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 07:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 11:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 12:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:31:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-19 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-19 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-19 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87620, 'Database Backup [database_backup_2024-09-20-00-00-05-v3-1-6.zip]', '2024-09-20 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:07:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:29:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:51:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 03:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:43:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 10:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 10:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 10:59:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (87999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 16:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 19:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88311, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 181.118.42.203]', '2024-09-20 20:36:26', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:41:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-20 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-20 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-20 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88429, 'Database Backup [database_backup_2024-09-21-00-04-03-v3-1-6.zip]', '2024-09-21 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 00:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 14:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 15:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 15:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 16:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (88999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 16:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 17:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 19:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 19:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 19:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 19:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89141, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-09-21 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 22:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 22:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 22:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 23:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 23:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 23:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-21 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-21 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-21 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89247, 'Database Backup [database_backup_2024-09-22-00-04-02-v3-1-6.zip]', '2024-09-22 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 00:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 00:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 00:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 00:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 00:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 00:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 00:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 01:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 01:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 01:01:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 01:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 01:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 01:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 01:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 01:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 02:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 02:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 02:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 02:37:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 02:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 02:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 02:53:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 03:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 03:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 03:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 03:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 03:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 03:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 03:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 03:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:09:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:17:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 10:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:49:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 20:57:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 21:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (89999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:19:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-22 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-22 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-22 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90061, 'Database Backup [database_backup_2024-09-23-00-04-02-v3-1-6.zip]', '2024-09-23 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 01:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:27:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 03:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 05:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:21:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 08:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 11:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 12:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:23:00', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 13:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-09-23 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-09-23 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (90570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-09-23 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log