#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=325595 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (298999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:43:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:31:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 12:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 12:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 12:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:52:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:52:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:52:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:30:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:41:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 14:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:19:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:35:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:46:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 15:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:12:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:12:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:12:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:28:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:38:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 16:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 16:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 16:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:33:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 18:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 18:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 18:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 19:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299541, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-06-10 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 21:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:33:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-10 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-10 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-10 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299647, 'Database Backup [database_backup_2025-06-11-00-02-04-v3-1-6.zip]', '2025-06-11 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 00:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 01:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 02:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 02:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 02:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 05:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 06:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 06:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 06:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (299999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 10:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 10:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 10:54:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:38:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:43:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 11:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 11:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 11:59:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:03:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:03:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:41:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:41:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:41:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:41:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 13:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 13:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 13:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:47:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 14:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 14:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 14:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 15:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 15:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 15:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:31:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 16:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 16:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 16:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 17:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 17:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 17:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 18:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 18:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 18:59:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 19:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300401, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-06-11 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:31:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:31:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:31:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:31:24', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:31:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:31:25', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 22:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-11 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-11 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-11 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300516, 'Database Backup [database_backup_2025-06-12-00-04-04-v3-1-6.zip]', '2025-06-12 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300517, 'Database Backup [database_backup_2025-06-12-00-04-04-v3-1-6.zip]', '2025-06-12 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 00:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 00:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 00:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 01:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 13:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 13:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 13:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 13:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 13:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 13:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 13:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 13:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 13:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 13:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 13:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 13:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 13:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 13:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 13:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:09:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300584, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:09:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300588, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:15:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:21:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300592, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:21:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:27:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300596, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:27:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:32:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300600, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:32:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:38:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300604, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:38:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300608, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:49:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300612, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:49:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300613, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:cbfd:996a:1289:9624:857e]', '2025-06-12 14:52:59', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 14:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 14:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 14:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300617, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 14:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300621, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:06:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300625, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:06:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:12:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300629, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:12:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:18:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300633, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:18:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300637, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:24:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300641, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:36:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300645, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:36:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300649, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 15:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300653, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:07:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:13:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300657, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:13:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300661, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300665, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300669, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300673, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300677, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:47:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300681, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:47:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300685, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:53:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 16:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 16:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 16:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300689, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 16:58:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300693, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300697, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:10:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:16:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300701, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:16:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300705, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:22:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300709, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:28:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300713, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:39:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300717, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:39:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300721, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:45:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300725, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:50:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 17:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 17:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 17:56:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300729, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 17:56:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300730, 'Invoice Status Updated [Invoice Number: INV-175/06/2025, From: Draft To: Unpaid]', '2025-06-12 17:58:37', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300734, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:02:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:07:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:07:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300738, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:07:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300742, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:13:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:18:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300746, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:18:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300750, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:24:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300754, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300758, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:42:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300762, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:42:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300766, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 18:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 18:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 18:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300770, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 18:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300774, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:05:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300778, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:05:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:11:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300782, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:11:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300786, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:22:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300790, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:22:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300794, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300798, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300802, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:40:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300806, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300810, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300811, 'Invoice Status Updated [Invoice Number: INV-175/06/2025, From: Unpaid To: Paid]', '2025-06-12 19:53:34', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300812, 'Payment Recorded [ID:127, Invoice Number: INV-175/06/2025, Total: $820.00]', '2025-06-12 19:53:34', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300816, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 19:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300820, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300824, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300828, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300832, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300836, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300840, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300844, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300848, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300852, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 20:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300856, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 20:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:01:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:01:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:01:34', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300860, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:01:40', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300864, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300868, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300872, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300876, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300880, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300884, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300888, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300892, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300896, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:53:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300900, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 21:59:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300904, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300908, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:11:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300912, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300916, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300920, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300924, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300928, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300932, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300936, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 22:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300940, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 22:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300944, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300948, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300952, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300956, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300960, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300964, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300968, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300972, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:40:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300976, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300980, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-12 23:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-12 23:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-12 23:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300984, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-12 23:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300988, 'Database Backup [database_backup_2025-06-13-00-04-04-v3-1-6.zip]', '2025-06-13 00:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300989, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300993, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:10:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300997, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (300999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301001, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301005, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301009, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:33:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301013, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301017, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301021, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:50:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 00:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 00:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 00:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301025, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 00:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 01:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301029, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 01:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301033, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 01:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 01:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 01:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 01:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301037, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 01:13:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 01:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 01:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 01:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301041, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 01:19:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 01:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 01:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 01:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301045, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 01:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301049, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 01:30:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 01:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301053, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 01:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301057, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 01:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 01:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 01:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 01:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301061, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 01:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 01:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301065, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 01:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 02:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301069, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 02:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 02:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301073, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 02:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 02:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301077, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 02:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 02:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 02:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 02:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301081, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 02:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 02:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301085, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 02:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 02:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 02:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 02:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301089, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 02:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301093, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 02:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 02:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 02:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 02:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301097, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 02:40:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 02:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 02:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 02:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301101, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 02:45:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 02:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 02:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 02:50:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301105, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 02:50:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 02:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 02:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 02:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301109, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 02:56:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 03:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 03:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 03:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301113, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 03:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301117, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 03:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 03:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 03:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 03:14:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301121, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 03:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 03:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301125, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 03:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 03:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 03:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 03:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301129, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 03:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 03:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301133, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 03:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 03:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 03:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 03:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301137, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 03:38:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 03:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 03:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 03:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301141, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 03:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 03:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301145, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 03:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 03:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 03:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 03:56:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301149, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 03:56:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 04:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 04:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 04:02:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301153, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 04:02:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 04:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 04:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 04:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301157, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 04:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301161, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 04:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 04:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 04:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 04:20:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301165, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 04:20:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301169, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 04:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301173, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 04:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 04:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 04:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 04:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301177, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 04:37:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 04:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 04:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 04:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301181, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 04:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 04:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 04:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 04:49:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301185, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 04:49:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 04:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 04:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 04:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301189, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 04:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 05:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301193, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 05:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 05:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 05:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 05:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301197, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 05:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 05:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 05:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 05:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301201, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 05:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 05:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301205, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 05:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 05:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 05:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 05:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301209, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 05:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301213, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 05:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 05:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 05:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 05:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301217, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 05:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 05:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301221, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 05:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301225, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 05:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 05:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 05:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 05:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301229, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 05:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 05:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 05:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 05:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301233, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 05:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301237, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 06:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 06:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 06:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301241, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 06:10:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 06:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 06:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 06:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301245, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 06:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 06:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 06:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 06:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301249, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 06:22:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301253, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 06:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301257, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 06:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301261, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 06:40:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 06:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301265, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 06:45:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 06:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301269, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 06:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 06:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301273, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 06:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 07:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 07:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 07:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301277, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 07:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301281, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 07:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301285, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 07:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301289, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 07:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 07:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 07:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 07:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301293, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 07:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 07:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 07:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 07:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301297, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 07:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301301, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 07:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 07:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 07:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 07:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301305, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 07:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 07:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 07:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 07:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301309, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 07:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 07:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 07:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 07:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301313, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 07:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 07:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 07:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 07:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301317, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 07:59:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 08:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 08:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 08:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301321, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 08:05:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 08:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301325, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 08:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 08:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 08:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 08:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301329, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 08:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 08:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 08:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 08:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301333, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 08:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 08:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 08:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 08:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301337, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 08:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 08:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 08:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 08:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301341, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 08:34:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 08:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 08:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 08:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301345, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 08:40:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 08:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 08:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 08:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301349, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 08:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301353, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 08:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 08:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 08:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 08:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301357, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 08:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301361, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 09:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 09:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 09:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 09:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301365, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 09:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301369, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 09:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 09:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 09:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 09:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301373, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 09:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301377, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 09:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 09:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 09:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 09:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301381, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 09:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 09:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 09:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 09:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301385, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 09:37:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 09:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 09:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 09:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301389, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 09:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 09:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301393, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 09:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 09:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 09:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 09:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301397, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 09:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301401, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 10:00:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 10:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 10:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 10:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301405, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 10:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 10:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 10:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 10:12:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301409, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 10:12:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 10:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 10:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 10:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301413, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 10:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 10:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 10:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 10:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301417, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 10:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 10:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 10:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 10:29:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301421, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 10:29:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 10:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 10:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 10:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301425, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 10:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 10:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 10:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 10:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301429, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 10:40:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 10:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 10:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 10:45:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301433, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 10:45:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 10:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 10:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 10:51:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301437, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 10:51:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 10:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 10:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 10:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301441, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 10:57:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 11:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 11:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 11:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301445, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 11:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 11:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 11:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 11:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301449, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 11:08:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 11:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 11:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 11:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301453, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 11:14:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 11:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 11:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 11:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301457, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 11:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 11:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 11:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 11:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301461, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 11:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 11:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 11:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 11:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301465, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 11:31:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 11:36:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 11:36:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 11:36:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301469, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 11:36:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 11:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301473, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 11:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 11:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 11:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 11:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301477, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 11:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 11:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 11:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 11:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301481, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 11:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 12:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 12:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 12:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301485, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 12:00:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 12:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 12:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 12:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301489, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 12:06:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 12:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 12:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 12:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301493, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 12:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 12:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 12:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 12:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301497, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 12:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 12:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 12:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 12:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301501, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 12:24:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 12:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 12:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 12:30:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301505, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 12:30:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 12:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 12:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 12:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301509, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 12:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 12:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 12:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 12:42:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301513, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 12:42:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 12:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 12:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 12:47:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301517, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 12:47:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 12:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 12:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 12:53:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301521, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 12:53:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 12:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 12:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 12:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301525, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 12:59:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 13:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301529, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 13:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 13:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 13:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 13:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301533, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 13:10:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 13:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 13:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 13:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301537, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 13:16:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 13:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 13:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 13:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301541, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 13:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 13:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 13:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 13:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301545, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 13:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 13:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 13:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 13:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301549, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 13:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 13:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 13:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 13:40:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301553, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 13:40:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 13:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 13:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 13:45:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301557, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 13:45:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 13:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 13:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 13:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301561, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 13:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 13:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 13:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 13:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301565, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 13:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 14:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 14:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 14:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301569, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 14:02:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 14:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 14:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 14:08:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301573, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 14:08:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 14:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 14:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 14:14:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301577, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 14:14:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 14:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 14:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 14:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301581, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 14:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 14:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 14:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 14:26:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301585, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 14:26:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 14:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 14:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 14:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301589, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 14:32:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 14:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 14:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 14:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301593, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 14:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 14:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 14:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 14:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301597, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 14:43:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 14:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 14:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 14:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301601, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 14:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 14:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 14:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 14:55:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301605, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 14:55:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 15:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 15:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 15:00:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301609, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 15:00:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 15:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 15:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 15:06:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301613, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 15:06:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 15:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 15:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 15:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301617, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 15:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 15:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 15:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 15:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301621, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 15:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 15:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 15:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 15:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301625, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 15:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301629, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 15:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301633, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 15:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301637, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 15:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 15:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 15:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 15:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301641, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 15:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 15:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 15:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 15:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301645, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 15:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 15:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 15:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 15:59:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301649, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 15:59:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 16:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 16:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 16:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301653, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 16:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 16:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 16:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 16:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301657, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 16:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 16:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 16:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 16:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301661, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 16:16:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 16:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 16:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 16:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301665, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 16:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 16:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 16:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 16:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301669, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 16:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 16:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 16:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 16:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301673, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 16:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 16:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301677, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 16:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 16:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 16:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 16:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301681, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 16:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 16:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301685, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 16:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 16:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 16:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 16:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301689, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 16:58:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 17:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 17:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 17:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301693, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 17:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 17:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 17:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 17:10:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301697, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 17:10:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 17:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 17:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 17:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301701, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 17:16:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 17:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 17:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 17:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301705, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 17:22:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 17:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 17:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 17:27:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301709, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 17:27:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 17:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 17:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 17:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301713, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 17:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 17:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 17:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 17:39:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301717, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 17:39:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 17:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 17:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 17:44:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301721, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 17:44:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 17:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 17:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 17:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301725, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 17:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 17:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 17:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 17:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301729, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 17:55:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 18:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 18:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 18:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301733, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 18:01:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 18:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 18:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 18:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301737, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 18:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 18:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 18:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 18:13:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301741, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 18:13:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 18:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 18:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 18:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301745, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 18:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301749, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 18:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 18:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301753, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 18:30:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301757, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 18:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 18:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 18:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301761, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 18:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 18:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 18:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 18:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301765, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 18:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301769, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 18:53:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 18:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 18:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 18:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301773, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 18:58:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 19:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 19:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 19:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301777, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 19:04:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 19:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 19:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 19:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301781, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 19:10:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 19:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 19:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 19:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301785, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 19:15:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 19:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301789, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 19:21:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 19:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 19:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 19:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301793, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 19:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 19:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 19:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 19:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301797, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 19:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 19:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 19:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 19:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301801, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 19:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 19:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 19:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 19:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301805, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 19:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 19:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 19:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 19:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301809, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 19:50:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 19:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 19:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 19:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301813, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 19:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 20:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 20:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 20:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301817, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 20:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301821, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 20:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 20:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 20:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 20:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301825, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 20:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 20:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 20:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 20:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301829, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 20:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 20:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 20:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 20:25:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301833, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 20:25:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301837, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 20:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301841, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 20:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 20:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 20:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 20:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301845, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 20:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 20:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 20:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 20:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301849, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 20:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 20:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301853, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 20:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 21:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301857, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 21:00:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 21:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 21:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 21:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301861, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 21:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301865, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 21:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 21:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 21:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 21:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301869, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 21:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 21:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 21:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 21:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301873, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 21:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 21:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 21:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 21:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301877, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 21:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 21:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 21:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 21:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301881, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 21:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 21:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 21:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 21:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301885, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 21:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 21:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 21:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 21:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301889, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 21:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301893, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 21:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 22:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301897, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 22:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 22:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 22:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 22:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301901, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 22:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 22:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 22:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 22:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301905, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 22:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 22:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301909, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 22:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 22:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 22:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 22:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301913, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 22:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 22:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 22:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 22:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301917, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 22:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 22:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 22:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 22:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301921, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 22:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301925, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 22:40:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 22:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301929, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 22:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301933, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 22:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301937, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 22:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301941, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 23:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 23:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 23:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 23:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301945, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 23:10:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 23:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301949, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 23:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 23:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 23:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 23:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301953, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 23:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 23:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301957, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 23:27:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 23:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 23:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 23:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301961, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 23:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 23:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 23:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 23:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301965, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 23:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 23:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 23:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 23:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301969, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 23:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301973, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 23:51:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-13 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-13 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-13 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301977, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-13 23:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 00:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 00:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 00:01:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301981, 'Database Backup [database_backup_2025-06-14-00-01-07-v3-1-6.zip]', '2025-06-14 00:01:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301982, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 00:01:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 00:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301986, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 00:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 00:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 00:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 00:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301990, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 00:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 00:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 00:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 00:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301994, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 00:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 00:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 00:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 00:24:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301998, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 00:24:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (301999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 00:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 00:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 00:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302002, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 00:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 00:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 00:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 00:36:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302006, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 00:36:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 00:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 00:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 00:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302010, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 00:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302014, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 00:48:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 00:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302018, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 00:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 01:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302022, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 01:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 01:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 01:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 01:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302026, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 01:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302030, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 01:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302034, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 01:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 01:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 01:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 01:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302038, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 01:22:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 01:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 01:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 01:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302042, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 01:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 01:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 01:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 01:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302046, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 01:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 01:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 01:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 01:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302050, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 01:40:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 01:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 01:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 01:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302054, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 01:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 01:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 01:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 01:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302058, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 01:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 01:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 01:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 01:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302062, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 01:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 02:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 02:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 02:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302066, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 02:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 02:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 02:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 02:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302070, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 02:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302074, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 02:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 02:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 02:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 02:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302078, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 02:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 02:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 02:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 02:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302082, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 02:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 02:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302086, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 02:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 02:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 02:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 02:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302090, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 02:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 02:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 02:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 02:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302094, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 02:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 02:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 02:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 02:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302098, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 02:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 02:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 02:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 02:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302102, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 02:54:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 03:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 03:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 03:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302106, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 03:00:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302110, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 03:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302114, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 03:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 03:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 03:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 03:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302118, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 03:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 03:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302122, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 03:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302126, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 03:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 03:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 03:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 03:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302130, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 03:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 03:41:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 03:41:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 03:41:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302134, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 03:41:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 03:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 03:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 03:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302138, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 03:47:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302142, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 03:53:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 03:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 03:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 03:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302146, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 03:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302150, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302154, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302158, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302162, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:22:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302166, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302170, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302174, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302178, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:45:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302182, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 04:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302186, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 04:56:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302190, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:01:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302194, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:07:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302198, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302202, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:19:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302206, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302210, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302214, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302218, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302222, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:48:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 05:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302226, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 05:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302230, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302234, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302238, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302242, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302246, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302250, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:30:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302254, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302258, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302262, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302266, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 06:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 06:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 06:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302270, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 06:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:04:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302274, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:09:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302278, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:09:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302282, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:15:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302286, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302290, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302294, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302298, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302302, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302306, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 07:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 07:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 07:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302310, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 07:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302314, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302318, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302322, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302326, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302330, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302334, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302338, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302342, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302346, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302350, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:53:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 08:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 08:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 08:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302354, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 08:58:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302358, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302362, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302366, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302370, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302374, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302378, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:33:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302382, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:39:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302386, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302390, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 09:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 09:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 09:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302394, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 09:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302398, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302402, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302406, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302410, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302414, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302418, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:32:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302422, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302426, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302430, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 10:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302434, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 10:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302438, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:00:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302442, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302446, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302450, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302454, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:24:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302458, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:30:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302462, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:35:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302466, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:40:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302470, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:51:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302474, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:51:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302478, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 11:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302482, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302486, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302490, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302494, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:25:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302498, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:25:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302502, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302506, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302510, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302514, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:49:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 12:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 12:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 12:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302518, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 12:55:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302522, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302526, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302530, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302534, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:24:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302538, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:24:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302542, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302546, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:36:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302550, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:41:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:46:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302554, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302558, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 13:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 13:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 13:58:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302562, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 13:58:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302566, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:10:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302570, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:10:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302574, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:22:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302578, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:22:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302582, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302586, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302590, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302594, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:45:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302598, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 14:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 14:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 14:56:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302602, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 14:56:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302606, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:08:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302610, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:08:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302614, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:19:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302618, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:19:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302622, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302626, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:30:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302630, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302634, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302638, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 15:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 15:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 15:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302642, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 15:54:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302646, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302650, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302654, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302658, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302662, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302666, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:28:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302670, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302674, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302678, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:45:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302682, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 16:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 16:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 16:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302686, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 16:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302690, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:02:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302694, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:07:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302698, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302702, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302706, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:24:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302710, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:35:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302714, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:35:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:41:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302718, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:41:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302722, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302726, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:52:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 17:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302730, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 17:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302734, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302738, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302742, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:15:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302746, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:21:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302750, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:27:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:32:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302754, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:32:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302758, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302762, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302766, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 18:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 18:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 18:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302770, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 18:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302774, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302778, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302782, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:12:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:18:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302786, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:18:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302790, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:29:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302794, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:29:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302798, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302802, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:40:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:45:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302806, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:45:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302810, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:51:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 19:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 19:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 19:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302814, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 19:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302818, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:08:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302822, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:08:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302826, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:19:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302830, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:19:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302834, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:25:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302838, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:30:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302842, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302846, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:42:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302850, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:53:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302854, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:53:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 20:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 20:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 20:58:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302858, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 20:58:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302862, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302866, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:10:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302870, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302874, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302878, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302882, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302886, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302890, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:48:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302894, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:48:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 21:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302898, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 21:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302902, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302906, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:06:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302910, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:11:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:17:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302914, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:17:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302918, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302922, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302926, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302930, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:40:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302934, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302938, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 22:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302942, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 22:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302946, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:09:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302950, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302954, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:15:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302958, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:21:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302962, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:26:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302966, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:32:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302970, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:38:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302974, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:44:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302978, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:50:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-14 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-14 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-14 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302982, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-14 23:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302986, 'Database Backup [database_backup_2025-06-15-00-02-06-v3-1-6.zip]', '2025-06-15 00:02:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302987, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:02:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302991, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:08:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302995, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:14:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (302999, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:20:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:25:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303003, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:25:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303007, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:37:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303011, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:37:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:43:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303015, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:43:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303019, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 00:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 00:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 00:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303023, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 00:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303027, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303031, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:11:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303035, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:11:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303039, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:17:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303043, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:23:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303047, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303051, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303055, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303059, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:46:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303063, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 01:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 01:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 01:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303067, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 01:57:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303071, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303075, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303079, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:14:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303083, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:20:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303087, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303091, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303095, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303099, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:50:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303103, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:50:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 02:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 02:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 02:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303107, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 02:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303111, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:02:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303115, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:08:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303119, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:13:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303123, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:19:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303127, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:25:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303131, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:31:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303135, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:37:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303139, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:43:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303143, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 03:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 03:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 03:54:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303147, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 03:54:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303151, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303155, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:06:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303159, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303163, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303167, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303171, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:30:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303175, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:36:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303179, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:42:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303183, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:47:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303187, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:53:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 04:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 04:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 04:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303191, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 04:59:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303195, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:05:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303199, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:11:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303203, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:17:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303207, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303211, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303215, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303219, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303223, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303227, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:52:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303231, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 05:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303235, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303239, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303243, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303247, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303251, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303255, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303259, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:40:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303263, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303267, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 06:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 06:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 06:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303271, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 06:58:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303275, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303279, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:10:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303283, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:16:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303287, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:22:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303291, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:28:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303295, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:34:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303299, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:39:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303303, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:45:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303307, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:51:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303311, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 07:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303315, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303319, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:09:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303323, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303327, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:20:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303331, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:26:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303335, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:31:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303339, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:37:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303343, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:43:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303347, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:48:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 08:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303351, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 08:54:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303355, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:00:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303359, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303363, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:12:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303367, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:18:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303371, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:23:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303375, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:29:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303379, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303383, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303387, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:46:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303391, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303395, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 09:58:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303399, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303403, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:10:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303407, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:16:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:22:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303411, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:22:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303415, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:28:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303419, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:34:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303423, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:40:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303427, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303431, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:52:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 10:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 10:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 10:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303435, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 10:57:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303439, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:03:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303443, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:09:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:14:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303447, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:14:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:20:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303451, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:20:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303455, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:26:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303459, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:32:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303463, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:38:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303467, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:44:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303471, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:49:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 11:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303475, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 11:55:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303479, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303483, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:06:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303487, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:12:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303491, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:18:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303495, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:24:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303499, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:29:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303503, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:35:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-06-15 12:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303507, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-06-15 12:41:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-06-15 12:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (303509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-06-15 12:46:04', '[CRON]');
INSERT INTO `