#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=170369 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (145999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 07:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 08:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 11:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 14:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 15:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146313, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.191]', '2024-12-02 16:55:39', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 19:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146446, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-02 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:02:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-02 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-02 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-02 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146549, 'Database Backup [database_backup_2024-12-03-00-04-02-v3-1-6.zip]', '2024-12-03 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 05:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 06:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (146999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 14:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 16:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 18:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-03 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-03 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-03 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147342, 'Database Backup [database_backup_2024-12-04-00-04-02-v3-1-6.zip]', '2024-12-04 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 01:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 02:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147808, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 200.7.90.180]', '2024-12-04 14:22:25', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 14:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (147999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 20:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-04 23:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148130, 'Database Backup [database_backup_2024-12-05-00-03-02-v3-1-6.zip]', '2024-12-05 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 00:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 01:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 04:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 08:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 09:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 10:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 11:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:27:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 13:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 14:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 16:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 18:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 19:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 20:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148824, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2024-12-05 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 21:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 22:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-05 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-05 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-05 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148927, 'Database Backup [database_backup_2024-12-06-00-03-01-v3-1-6.zip]', '2024-12-06 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (148999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 04:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 10:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 12:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 14:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 15:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 18:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 20:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 22:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-06 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-06 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-06 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149729, 'Database Backup [database_backup_2024-12-07-00-03-01-v3-1-6.zip]', '2024-12-07 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 02:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 03:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 07:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (149999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 08:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 09:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 10:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 12:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 13:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 14:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 16:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2024-12-07 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2024-12-07 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (150325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2024-12-07 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log