#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=346640 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 05:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 06:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 08:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 11:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:04:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:43:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323822, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:cc9e:e2f5:f4c8:c6ba]', '2025-07-07 15:47:51', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323823, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:cc9e:e2f5:f4c8:c6ba]', '2025-07-07 15:47:51', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 15:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:10:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323986, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-07 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (323999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-07 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-07 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-07 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324080, 'Database Backup [database_backup_2025-07-08-00-03-02-v3-3-1.zip]', '2025-07-08 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 00:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 03:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 05:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:44:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 07:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 08:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324366, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:cc9e:e2f5:f4c8:c6ba]', '2025-07-08 09:18:03', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324370, 'Email Sent To [Email: naresh.sookhan@gmail.com, Template: Send Invoice to Customer]', '2025-07-08 09:24:41', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 10:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 11:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 11:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 11:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:23:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:45:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 13:54:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 15:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 17:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 19:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 20:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 22:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-08 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-08 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-08 23:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324830, 'Database Backup [database_backup_2025-07-09-00-01-06-v3-3-1.zip]', '2025-07-09 00:01:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324888, 'User Successfully Logged In [User Id: 2, Is Staff Member: Yes, IP: 2803:1500:1c00:95cc:e46b:ac35:ac80:6a7e]', '2025-07-09 01:55:17', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324889, 'Non Existing User Tried to Login [Email: admin@saylessdigital.io, Is Staff Member: No, IP: 2803:1500:1c00:95cc:e46b:ac35:ac80:6a7e]', '2025-07-09 01:55:37', 'Dallas Ferdinand');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 01:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 02:57:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 02:57:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 02:57:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 03:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 04:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 04:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 04:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (324999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 05:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 05:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 05:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 06:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:53:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 12:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:33:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:34:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 14:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 14:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 14:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 15:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:50:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 16:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 18:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 18:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 18:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 20:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325493, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-09 21:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325494, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-07-09 21:00:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325495, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-07-09 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:00:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:00:15', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 21:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 21:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 21:56:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 22:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 22:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 22:55:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-09 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-09 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-09 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325595, 'Database Backup [database_backup_2025-07-10-00-03-02-v3-3-1.zip]', '2025-07-10 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 00:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 00:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 00:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:23:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:23:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:23:12', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:46:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:46:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:46:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 04:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 07:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 07:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 07:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 09:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:20:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:12:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:40:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 11:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 12:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (325999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:06:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:28:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 13:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 13:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 13:58:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:50:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 16:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 17:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 18:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 19:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326250, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-10 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-10 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-10 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-10 23:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326350, 'Database Backup [database_backup_2025-07-11-00-02-18-v3-3-1.zip]', '2025-07-11 00:02:19', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326366, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326367, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326368, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326369, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326370, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326371, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326372, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326373, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326374, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326375, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326376, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326377, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 00:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326378, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326379, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326380, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326381, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326382, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326383, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326384, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326385, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326386, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326387, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326388, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326389, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326390, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326391, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326392, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326393, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326394, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326395, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326396, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326397, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326398, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326399, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326400, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326401, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326402, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326405, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326406, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326407, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326408, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326409, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326410, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326411, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326412, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326413, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326414, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326415, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326416, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326417, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326418, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326419, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326420, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326421, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326422, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326423, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326424, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326425, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326426, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326427, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326428, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326429, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326430, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326431, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326432, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326433, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326434, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326435, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326436, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326437, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326438, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326439, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326440, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326441, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326442, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326443, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 02:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326444, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326445, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326446, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326447, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326448, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326449, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326450, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326453, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326454, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326455, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326456, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326457, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326458, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326459, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326460, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326461, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326462, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326463, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326464, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326465, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326466, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326467, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326468, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326469, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326470, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326472, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326473, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326474, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326475, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326476, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326477, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326478, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326479, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326480, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326481, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326482, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326483, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326484, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326485, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326486, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326487, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326488, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326489, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326490, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326491, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326495, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326496, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326497, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326498, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326499, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326500, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326501, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326502, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326503, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 04:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326504, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326505, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326506, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326507, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326508, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326509, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326510, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326511, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326512, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326513, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326514, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326515, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326516, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326517, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326518, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326519, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326520, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326521, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326522, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326523, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326524, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326525, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326526, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326527, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326528, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326529, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326530, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326531, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326532, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326533, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326534, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326535, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326536, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326537, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326538, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326539, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326540, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326541, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326542, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326543, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326544, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326545, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326546, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326547, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326548, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326549, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326550, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326551, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:46:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 08:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 09:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 10:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:52:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:26:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:26:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:26:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:38:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:44:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 15:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 15:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 15:56:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 17:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 18:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 19:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (326999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 20:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327002, 'Email Sent To [Email: naresh.sookhan@gmail.com, Template: Invoice Due Notice]', '2025-07-11 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:03:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 21:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-11 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-11 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-11 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327099, 'Database Backup [database_backup_2025-07-12-00-02-02-v3-3-1.zip]', '2025-07-12 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 00:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:34:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 04:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 06:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:41:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 11:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 13:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 15:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 16:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 17:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 18:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 19:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327748, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-07-12 21:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327749, 'Email Sent To [Email: wendyannpompey@wssmsolutions.com, Template: Invoice Overdue Notice]', '2025-07-12 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327750, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-07-12 21:05:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327751, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Send Invoice to Customer]', '2025-07-12 21:05:14', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327752, 'Email sent to: tishara.f@saylesstt.com Subject: Recurring Invoices Cron Job Activity', '2025-07-12 21:05:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327753, 'Email sent to: clientportal@saylesstt.com Subject: Recurring Invoices Cron Job Activity', '2025-07-12 21:05:18', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327754, 'Email sent to: dallas.f@saylesstt.com Subject: Recurring Invoices Cron Job Activity', '2025-07-12 21:05:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:05:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:05:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:05:20', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-12 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-12 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-12 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327848, 'Database Backup [database_backup_2025-07-13-00-00-03-v3-3-1.zip]', '2025-07-13 00:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 00:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-07-13 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-07-13 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-07-13 01:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (327897, 'Failed to connect to IMAP auto importing tickets for 