#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=304991 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 04:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 04:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 04:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 05:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 05:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 05:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 05:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 05:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 05:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 05:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 05:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 05:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 05:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 06:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 06:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 06:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 06:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 06:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 06:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 06:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 06:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 07:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 07:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 07:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 08:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 08:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 08:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 08:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 08:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 08:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 09:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 09:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 09:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (279999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 09:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 10:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 10:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 10:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 11:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 11:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 11:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 11:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 11:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 11:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 11:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 11:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 11:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 12:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 12:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 12:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 12:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 12:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 12:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 12:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 12:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 13:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 13:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 13:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 13:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 13:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 13:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 14:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 14:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 14:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 14:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 15:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 15:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 15:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 15:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 15:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 15:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 15:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 15:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 16:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 16:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 16:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 16:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 16:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 16:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 17:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 17:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 17:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 17:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 17:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 17:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 17:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 17:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 17:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280267, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280268, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280269, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280270, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280271, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280272, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280273, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280274, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280275, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280276, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280277, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280278, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280279, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280280, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280281, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280282, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280283, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280284, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280285, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280286, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280287, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280288, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280289, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280290, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 18:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280291, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280292, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280293, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 18:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280294, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280295, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280296, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280297, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280298, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280299, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280300, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280301, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280302, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 19:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280303, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280304, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280305, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280306, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 19:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280307, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 19:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280308, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 19:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280309, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280310, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280311, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280312, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280315, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280316, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280317, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280318, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280319, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280320, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280321, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280322, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280324, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280325, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280326, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280327, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280330, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280331, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280332, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280333, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280334, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280335, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280336, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 20:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280337, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 20:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280338, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 20:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280339, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280340, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280341, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 20:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280342, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280343, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280345, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280346, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280347, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280348, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280349, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280350, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280351, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280352, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280353, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 20:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280354, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280355, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280356, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 20:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280357, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280358, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280359, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 20:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280360, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280361, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280362, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 20:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280363, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 20:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280364, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 20:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280365, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 20:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280366, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-17 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 21:03:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 21:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 21:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 21:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 21:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 22:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 22:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 23:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 23:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 23:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 23:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 23:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 23:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-17 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-17 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-17 23:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 00:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280469, 'Database Backup [database_backup_2025-05-18-00-05-02-v3-1-6.zip]', '2025-05-18 00:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 00:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 00:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 00:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 00:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 00:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 00:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 00:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 00:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 00:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 00:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 00:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 01:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 01:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 01:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 02:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 02:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 02:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 02:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 02:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 02:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 02:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 02:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 02:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 02:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 02:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 02:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 03:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 03:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 03:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 03:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 03:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 03:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 03:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 03:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 03:46:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 04:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 04:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 04:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 04:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 04:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 04:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 04:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 04:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 04:45:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 04:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 04:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 05:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 05:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 05:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 05:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 05:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 05:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 05:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 05:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 05:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 06:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 06:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 06:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 06:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 06:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 06:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 06:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 06:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 06:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 06:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 07:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 07:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 07:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 07:05:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 07:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 07:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 07:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 07:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 08:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 08:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 08:00:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 08:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 08:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 08:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 08:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 08:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 08:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 08:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 09:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 09:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 09:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 09:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 09:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 09:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 09:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 10:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 10:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 10:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 10:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 10:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 11:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 11:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 11:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 11:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 11:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 11:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 11:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 11:57:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 12:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280870, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280871, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 12:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 12:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 12:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 12:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 12:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 12:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 12:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 12:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 12:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 12:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 12:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280896, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280897, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 12:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 13:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 13:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 13:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 14:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 14:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 14:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 14:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 14:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 14:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280948, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280949, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 14:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280950, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 14:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 14:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 14:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 14:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 15:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 15:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 15:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 15:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 15:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 15:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 15:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (280999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 16:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 16:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 16:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 16:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 16:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 16:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 16:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 17:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 17:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 17:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 17:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 17:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 17:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 17:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 17:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 17:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 17:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 18:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 18:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 18:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 18:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 18:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 18:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 18:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 18:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 18:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 19:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 19:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 19:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 19:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 19:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 19:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 19:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 19:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 19:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 19:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 19:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 19:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 20:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 20:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281163, 'Invoice Status Updated [Invoice Number: INV-173/05/2025, From: Unpaid To: Overdue]', '2025-05-18 21:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281164, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-05-18 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 21:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 21:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 21:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 21:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 21:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 21:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 21:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 21:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 21:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 22:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 22:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 22:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 22:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 22:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 22:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 22:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 22:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 22:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 23:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 23:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 23:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 23:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 23:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 23:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 23:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 23:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-18 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-18 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-18 23:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281265, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281266, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 00:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281267, 'Database Backup [database_backup_2025-05-19-00-03-02-v3-1-6.zip]', '2025-05-19 00:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 00:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 00:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 00:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 00:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 00:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 00:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 00:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 00:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 00:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 00:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 00:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 00:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 01:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 01:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 01:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 01:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 01:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 01:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 01:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 01:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 01:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 01:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 02:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 02:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 02:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 02:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 02:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 02:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 02:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 02:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 03:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 03:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 03:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 03:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 03:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 03:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 03:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 03:26:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 03:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 03:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 03:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 03:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 03:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 04:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 04:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 04:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 04:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 04:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 04:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 04:48:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 04:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 04:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 04:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 05:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 05:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 05:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 05:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 05:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 05:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 05:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 05:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 06:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 06:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 06:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 06:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 06:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 06:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 06:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 06:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 06:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 07:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 07:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 07:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 07:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 07:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 08:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 08:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 08:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 08:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 08:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 08:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 08:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 08:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 09:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 09:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 09:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 09:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 09:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 09:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 09:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 10:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 10:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 10:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 10:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 10:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 10:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 10:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 10:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 10:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 10:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 11:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 11:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 11:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 11:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 11:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 11:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 11:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 11:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 11:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 11:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 11:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 11:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 11:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 11:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 12:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 12:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 12:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 12:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 12:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 12:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 12:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 12:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 12:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 12:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 12:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 12:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 13:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 13:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 13:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 13:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 13:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 13:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 13:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 13:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 13:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 14:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 14:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 14:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 14:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 14:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 14:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 14:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 14:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 14:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 15:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 15:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 15:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 15:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 15:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 15:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 15:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 15:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 15:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 15:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 15:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 16:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 16:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 16:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 16:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 16:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 16:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 16:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 16:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 17:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 17:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 17:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 17:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 17:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 17:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 17:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 17:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 17:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 18:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 18:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 18:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 18:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 18:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 18:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 18:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 18:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 18:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 19:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281899, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281900, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 19:16:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 19:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 19:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 19:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 19:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 19:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 19:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 19:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 19:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 19:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 19:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 20:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 20:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 20:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 20:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 20:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 20:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 20:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 20:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 20:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 20:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 20:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281958, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-19 21:04:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281959, 'Email Sent To [Email: projenbeauty@yahoo.com, Template: Invoice Overdue Notice]', '2025-05-19 21:04:13', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281960, 'Email Sent To [Email: rabiansutherland@gmail.com, Template: Invoice Overdue Notice]', '2025-05-19 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 21:04:16', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 21:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 21:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 21:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 21:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 21:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 21:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 21:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 21:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 21:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 21:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 22:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (281999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 22:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 22:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 22:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 22:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 22:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 22:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 22:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 22:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 22:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 22:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 22:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 23:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 23:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 23:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 23:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 23:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 23:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 23:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 23:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 23:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-19 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-19 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-19 23:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282063, 'Database Backup [database_backup_2025-05-20-00-02-03-v3-1-6.zip]', '2025-05-20 00:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 00:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 00:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 00:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 00:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 00:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 00:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 00:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 00:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 00:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 01:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 01:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 01:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 01:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 01:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 01:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 01:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 01:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 01:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 01:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 01:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 01:41:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 01:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 01:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 02:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 02:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 02:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 02:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 02:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 02:25:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 02:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 02:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 02:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 03:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 03:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 03:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 03:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 03:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 03:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 03:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 03:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 04:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 04:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 04:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 04:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 05:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 05:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 05:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 05:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 05:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 05:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 05:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 05:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 05:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 06:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 06:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 06:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 06:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 06:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 06:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 06:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 06:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 06:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 06:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 06:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 07:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 07:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 07:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 07:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 07:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 07:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 07:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 07:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 07:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 08:05:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 08:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 08:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 08:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 08:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 08:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 08:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 08:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 08:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 08:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 09:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 09:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 09:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 09:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 09:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 09:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 09:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 09:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 09:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 09:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 10:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 10:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 10:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 10:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 10:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 11:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 11:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 11:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 11:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282451, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282452, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 11:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 11:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 11:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 12:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 12:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282471, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 12:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 12:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 12:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 12:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 12:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 12:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 12:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 12:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 13:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 13:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 13:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 13:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 13:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 14:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 14:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 14:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 14:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 14:35:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 14:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 14:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 14:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 14:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 15:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 15:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 15:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 15:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 15:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 15:30:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 15:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 15:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 16:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 16:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 16:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 16:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 16:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 16:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 16:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 16:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 16:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 17:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 17:08:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 17:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 17:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 17:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 17:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 17:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 17:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 17:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 18:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 18:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 18:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 18:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 18:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 18:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 18:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 18:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 18:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 18:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 18:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 19:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 19:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 19:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 19:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 19:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 19:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 19:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 20:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 20:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 20:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 20:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 20:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 20:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 20:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 20:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282763, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-20 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 21:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 21:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 22:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 22:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 22:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 22:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 22:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 22:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 22:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 22:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 22:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 22:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 22:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 22:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 22:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 23:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 23:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 23:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 23:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 23:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 23:37:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 23:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 23:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 23:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-20 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-20 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-20 23:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 00:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282866, 'Database Backup [database_backup_2025-05-21-00-04-03-v3-1-6.zip]', '2025-05-21 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 00:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 00:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 00:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 00:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 00:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 00:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 00:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 00:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 01:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 01:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 01:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 01:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 01:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 01:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 01:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 01:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 01:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 01:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 01:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 01:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 02:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 02:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 02:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 02:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 02:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 02:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 02:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 02:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 03:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 03:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 03:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 03:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 03:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 03:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 03:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 03:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 03:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 03:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 03:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 04:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (282999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 04:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 04:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 04:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 04:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 05:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 05:15:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 05:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 05:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 05:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 05:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 05:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 06:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 06:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 06:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 06:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 06:47:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 07:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 07:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 07:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 07:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 07:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 07:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 07:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 07:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 07:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 07:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 08:03:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 08:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 08:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 08:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 08:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 09:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 09:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 09:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 09:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 10:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 10:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 10:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 10:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 10:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 10:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 10:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 10:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 10:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 10:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 10:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 10:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 11:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 11:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 11:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 11:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 11:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 11:19:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 11:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 11:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 11:24:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 11:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 11:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 11:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 11:36:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 11:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 11:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 11:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 11:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 12:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 12:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 12:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 12:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 12:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 12:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 12:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 12:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 12:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 13:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 13:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 13:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 13:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 13:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 13:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283322, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 13:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283323, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 13:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 14:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 14:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 14:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 14:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 14:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283344, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 14:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 15:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 15:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 15:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 15:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 15:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 15:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 15:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 15:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 15:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 15:49:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 15:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 16:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 16:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 16:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 16:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 16:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 16:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 16:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 17:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 17:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 17:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 17:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 17:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 17:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 17:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 17:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 17:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 17:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 17:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 17:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 17:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 17:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 18:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 18:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 18:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 18:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 18:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 18:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 18:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 18:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 18:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 18:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 18:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 18:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 18:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 18:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 18:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 18:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 19:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 19:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 19:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 19:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 19:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 19:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 19:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 19:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 19:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 19:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 19:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 20:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 20:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 20:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 20:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 20:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 20:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 20:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 20:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 20:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 20:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 20:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 20:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 20:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283560, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-05-21 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 21:05:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 21:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 21:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 21:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 21:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 21:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 21:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 21:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 21:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 21:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 22:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 22:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 22:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 22:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 22:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 22:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 22:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 22:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 22:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283622, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 22:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283623, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 22:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283624, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283625, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 22:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 23:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 23:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 23:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 23:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 23:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 23:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 23:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 23:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 23:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 23:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 23:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 23:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-21 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-21 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-21 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283663, 'Database Backup [database_backup_2025-05-22-00-02-05-v3-1-6.zip]', '2025-05-22 00:02:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 00:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 00:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 00:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 00:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 00:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 00:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 00:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 00:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 00:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 00:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 00:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 00:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 01:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 01:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 01:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 01:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 01:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 01:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283719, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283720, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 01:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283721, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283722, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 01:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 01:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 01:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 01:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 02:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 02:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 02:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 02:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 02:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 02:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 02:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 02:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 02:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 02:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 02:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 02:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 02:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 02:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 02:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 03:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 03:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 03:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 03:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 03:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 03:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 03:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 03:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 03:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 03:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 03:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 04:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 04:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 04:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 04:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 04:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 04:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 04:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 04:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 04:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 04:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 04:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 04:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 04:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 04:38:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 04:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 05:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 05:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 05:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 05:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 05:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 05:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 05:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 05:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 05:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 05:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 05:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 05:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 05:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 05:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 05:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 05:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 06:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 06:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 06:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 06:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 06:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 06:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283874, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283875, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 06:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 06:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 06:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 06:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 06:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283889, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-05-22 06:47:23', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 06:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283894, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283895, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 06:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283896, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-05-22 06:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 07:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283900, 'Failed to connect to IMAP from email: dallas.f@saylesstt.com', '2025-05-22 07:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283901, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283902, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 07:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 07:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 07:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 07:13:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 07:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 07:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 07:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 07:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 07:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 07:57:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 08:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 08:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 08:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 08:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 08:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 08:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 09:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 09:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 09:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 09:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (283999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 10:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 10:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 10:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 10:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 10:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284017, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284018, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284019, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284020, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284021, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284022, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284023, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 10:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284024, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284027, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 10:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284028, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 10:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284029, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 10:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284030, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284031, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284032, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 11:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284033, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284034, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284035, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 11:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284036, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284037, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284038, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284039, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284040, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284041, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284042, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284043, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284044, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 11:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284045, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284046, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284047, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 11:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284048, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284049, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284050, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284051, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 11:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284052, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 11:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284053, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 11:39:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284054, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284055, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284056, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284057, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284058, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284059, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 11:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284060, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 11:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284061, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 11:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284062, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 11:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284063, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284064, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284065, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 12:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284066, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284067, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284068, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284069, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284070, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284071, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284072, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284073, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284074, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 12:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284075, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284076, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284077, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 12:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284078, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 12:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284079, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 12:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284080, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 12:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284081, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284082, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284083, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 12:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284084, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284085, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284086, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284087, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284088, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284089, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 12:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284090, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284091, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284092, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 12:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284093, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284094, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284095, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 12:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284096, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284097, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284098, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 13:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284099, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284100, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284101, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 13:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284102, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284103, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284104, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 13:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284105, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284106, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284107, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 13:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284108, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284109, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284110, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 13:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284111, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284112, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284113, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 13:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284114, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284115, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284116, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 13:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284117, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284118, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284119, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 13:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284120, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284121, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284122, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 13:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284123, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284124, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284125, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 13:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284126, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284127, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284128, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 13:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284129, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284130, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284131, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284132, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284133, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284134, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 14:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284135, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284136, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284137, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 14:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284138, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284139, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284140, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 14:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284141, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284142, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284143, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 14:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284146, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 14:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284147, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284148, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284149, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 14:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284150, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284151, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284152, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 14:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284153, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284154, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284155, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284156, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284157, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284158, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 14:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284159, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284160, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284161, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 14:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284162, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284163, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284164, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 15:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284165, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284166, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284167, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 15:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284168, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284169, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284170, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 15:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284171, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 15:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284172, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 15:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284173, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 15:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284174, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284175, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284176, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 15:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284177, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 15:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284180, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284181, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284182, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284185, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 15:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284186, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284187, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284188, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284189, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284190, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284191, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284192, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 15:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284193, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 15:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284194, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 15:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284195, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284196, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284197, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284198, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284199, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284200, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 16:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284201, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284202, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284203, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284204, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284205, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284206, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 16:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284207, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284208, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284209, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284210, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284211, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284212, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 16:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284213, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284214, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284215, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 16:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284216, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284217, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284218, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 16:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284219, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284220, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284221, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 16:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284222, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284223, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284224, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 16:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284225, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284226, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284227, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284228, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284229, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284230, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284231, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 17:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284232, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 17:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284233, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 17:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284234, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284235, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284236, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 17:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284237, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284238, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284239, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284240, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284241, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284242, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 17:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284243, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284244, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284245, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 17:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284246, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 17:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 17:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 17:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284249, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284250, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284251, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 17:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284252, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 17:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284253, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 17:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284254, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 17:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284255, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284256, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284257, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 17:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284258, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284259, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284260, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 17:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284261, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284262, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-22 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284263, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-22 17:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284264, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-22 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (284265, 'Failed to connect to IMAP auto importing tickets for department 