#
# TABLE STRUCTURE FOR: tbl_perfex_email_builder
#

DROP TABLE IF EXISTS `tbl_perfex_email_builder`;

CREATE TABLE `tbl_perfex_email_builder` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `emailtemplateid` varchar(4) NOT NULL,
  `emailObject` text NOT NULL,
  `template` text NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_account_history
#

DROP TABLE IF EXISTS `tblacc_account_history`;

CREATE TABLE `tblacc_account_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `debit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `credit` decimal(15,2) NOT NULL DEFAULT 0.00,
  `description` text DEFAULT NULL,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(45) DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `customer` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `split` int(11) NOT NULL DEFAULT 0,
  `item` int(11) DEFAULT NULL,
  `paid` int(1) NOT NULL DEFAULT 0,
  `date` date DEFAULT NULL,
  `tax` int(11) DEFAULT NULL,
  `payslip_type` varchar(45) DEFAULT NULL,
  `vendor` int(11) DEFAULT NULL,
  `itemable_id` int(11) DEFAULT NULL,
  `cleared` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (1, 1, '230.00', '0.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 66, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (2, 66, '0.00', '230.00', '', 169, 'invoice', '2024-08-01 21:28:03', 3, 15, 0, 1, 0, 1, '2024-07-18', 0, NULL, NULL, 268, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (3, 13, '230.00', '0.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 1, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (4, 1, '0.00', '230.00', '', 107, 'payment', '2024-08-01 21:28:03', 3, 15, 0, 13, NULL, 0, '2024-08-01', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (5, 1, '2000.00', '0.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 66, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (6, 66, '0.00', '2000.00', '', 150, 'invoice', '2024-08-07 11:42:44', 2, 69, 0, 1, 0, 1, '2024-06-05', 0, NULL, NULL, 242, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (7, 13, '1000.00', '0.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (8, 1, '0.00', '1000.00', '', 108, 'payment', '2024-08-07 11:42:44', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (9, 1, '13000.00', '0.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 66, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (10, 66, '0.00', '13000.00', '', 118, 'invoice', '2024-08-07 11:44:57', 2, 69, 0, 1, 0, 1, '2024-03-15', 0, NULL, NULL, 185, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (11, 13, '2000.00', '0.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 1, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (12, 1, '0.00', '2000.00', '', 109, 'payment', '2024-08-07 11:44:57', 2, 69, 0, 13, NULL, 0, '2024-08-07', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (13, 1, '1000.00', '0.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 66, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (14, 66, '0.00', '1000.00', '', 171, 'invoice', '2024-08-09 17:32:02', 2, 9, 0, 1, 0, 0, '2024-07-20', 0, NULL, NULL, 270, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (17, 1, '210.00', '0.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 66, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (18, 66, '0.00', '210.00', '', 174, 'invoice', '2024-08-10 18:09:21', 2, 9, 0, 1, 0, 1, '2024-08-09', 0, NULL, NULL, 273, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (19, 13, '210.00', '0.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 1, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);
INSERT INTO `tblacc_account_history` (`id`, `account`, `debit`, `credit`, `description`, `rel_id`, `rel_type`, `datecreated`, `addedfrom`, `customer`, `reconcile`, `split`, `item`, `paid`, `date`, `tax`, `payslip_type`, `vendor`, `itemable_id`, `cleared`) VALUES (20, 1, '0.00', '210.00', '', 110, 'payment', '2024-08-10 18:09:21', 2, 9, 0, 13, NULL, 0, '2024-08-10', NULL, NULL, NULL, NULL, 0);


#
# TABLE STRUCTURE FOR: tblacc_account_type_details
#

DROP TABLE IF EXISTS `tblacc_account_type_details`;

CREATE TABLE `tblacc_account_type_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_type_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `note` text DEFAULT NULL,
  `statement_of_cash_flows` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=200 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_accounts
#

DROP TABLE IF EXISTS `tblacc_accounts`;

CREATE TABLE `tblacc_accounts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `key_name` varchar(255) DEFAULT NULL,
  `number` varchar(45) DEFAULT NULL,
  `parent_account` int(11) DEFAULT NULL,
  `account_type_id` int(11) NOT NULL,
  `account_detail_type_id` int(11) NOT NULL,
  `balance` decimal(15,2) DEFAULT NULL,
  `balance_as_of` date DEFAULT NULL,
  `description` text DEFAULT NULL,
  `default_account` int(11) NOT NULL DEFAULT 0,
  `active` int(11) NOT NULL DEFAULT 1,
  `access_token` text DEFAULT NULL,
  `account_id` varchar(255) DEFAULT NULL,
  `plaid_status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>verified, 0=>not verified',
  `plaid_account_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (1, '', 'acc_accounts_receivable', NULL, NULL, 1, 1, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (2, '', 'acc_accrued_holiday_payable', NULL, NULL, 9, 61, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (3, '', 'acc_accrued_liabilities', NULL, NULL, 8, 44, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (4, '', 'acc_accrued_non_current_liabilities', NULL, NULL, 9, 62, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (5, '', 'acc_accumulated_depreciation_on_property_plant_and_equipment', NULL, NULL, 4, 22, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (6, '', 'acc_allowance_for_bad_debts', NULL, NULL, 2, 2, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (7, '', 'acc_amortisation_expense', NULL, NULL, 14, 106, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (8, '', 'acc_assets_held_for_sale', NULL, NULL, 5, 32, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (9, '', 'acc_available_for_sale_assets_short_term', NULL, NULL, 2, 3, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (10, '', 'acc_bad_debts', NULL, NULL, 14, 108, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (11, '', 'acc_bank_charges', NULL, NULL, 14, 109, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (12, '', 'acc_billable_expense_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (13, '', 'acc_cash_and_cash_equivalents', NULL, NULL, 3, 15, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (14, '', 'acc_change_in_inventory_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (15, '', 'acc_commissions_and_fees', NULL, NULL, 14, 111, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (16, '', 'acc_cost_of_sales', NULL, NULL, 13, 104, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (17, '', 'acc_deferred_tax_assets', NULL, NULL, 5, 33, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (18, '', 'acc_direct_labour_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (19, '', 'acc_discounts_given_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (20, '', 'acc_dividend_disbursed', NULL, NULL, 10, 69, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (21, '', 'acc_dividend_income', NULL, NULL, 12, 92, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (22, '', 'acc_dividends_payable', NULL, NULL, 8, 48, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (23, '', 'acc_dues_and_subscriptions', NULL, NULL, 14, 113, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (24, '', 'acc_equipment_rental', NULL, NULL, 14, 114, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (25, '', 'acc_equity_in_earnings_of_subsidiaries', NULL, NULL, 10, 70, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (26, '', 'acc_freight_and_delivery_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (27, '', 'acc_goodwill', NULL, NULL, 5, 34, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (28, '', 'acc_income_tax_expense', NULL, NULL, 14, 116, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (29, '', 'acc_income_tax_payable', NULL, NULL, 8, 50, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (30, '', 'acc_insurance_disability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (31, '', 'acc_insurance_general', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (32, '', 'acc_insurance_liability', NULL, NULL, 14, 117, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (33, '', 'acc_intangibles', NULL, NULL, 5, 35, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (34, '', 'acc_interest_expense', NULL, NULL, 14, 118, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (35, '', 'acc_interest_income', NULL, NULL, 12, 93, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (36, '', 'acc_inventory', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (37, '', 'acc_inventory_asset', NULL, NULL, 2, 5, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (38, '', 'acc_legal_and_professional_fees', NULL, NULL, 14, 119, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (39, '', 'acc_liabilities_related_to_assets_held_for_sale', NULL, NULL, 9, 63, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (40, '', 'acc_long_term_debt', NULL, NULL, 9, 64, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (41, '', 'acc_long_term_investments', NULL, NULL, 5, 38, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (42, '', 'acc_loss_on_discontinued_operations_net_of_tax', NULL, NULL, 14, 120, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (43, '', 'acc_loss_on_disposal_of_assets', NULL, NULL, 12, 94, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (44, '', 'acc_management_compensation', NULL, NULL, 14, 121, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (45, '', 'acc_materials_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (46, '', 'acc_meals_and_entertainment', NULL, NULL, 14, 122, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (47, '', 'acc_office_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (48, '', 'acc_other_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (49, '', 'acc_other_comprehensive_income', NULL, NULL, 10, 73, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (50, '', 'acc_other_general_and_administrative_expenses', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (51, '', 'acc_other_operating_income_expenses', NULL, NULL, 12, 97, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (52, '', 'acc_other_selling_expenses', NULL, NULL, 14, 125, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (53, '', 'acc_other_type_of_expenses_advertising_expenses', NULL, NULL, 14, 105, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (54, '', 'acc_overhead_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (55, '', 'acc_payroll_clearing', NULL, NULL, 8, 55, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (56, '', 'acc_payroll_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (57, '', 'acc_payroll_liabilities', NULL, NULL, 8, 56, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (58, '', 'acc_prepaid_expenses', NULL, NULL, 2, 11, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (59, '', 'acc_property_plant_and_equipment', NULL, NULL, 4, 26, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (60, '', 'acc_purchases', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (61, '', 'acc_reconciliation_discrepancies', NULL, NULL, 15, 139, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (62, '', 'acc_rent_or_lease_payments', NULL, NULL, 14, 127, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (63, '', 'acc_repair_and_maintenance', NULL, NULL, 14, 128, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (64, '', 'acc_retained_earnings', NULL, NULL, 10, 80, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (65, '', 'acc_revenue_general', NULL, NULL, 11, 86, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (66, '', 'acc_sales', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (67, '', 'acc_sales_retail', NULL, NULL, 11, 87, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (68, '', 'acc_sales_wholesale', NULL, NULL, 11, 88, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (69, '', 'acc_sales_of_product_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (70, '', 'acc_share_capital', NULL, NULL, 10, 81, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (71, '', 'acc_shipping_and_delivery_expense', NULL, NULL, 14, 129, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (72, '', 'acc_short_term_debit', NULL, NULL, 8, 54, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (73, '', 'acc_stationery_and_printing', NULL, NULL, 14, 123, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (74, '', 'acc_subcontractors_cos', NULL, NULL, 13, 100, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (75, '', 'acc_supplies', NULL, NULL, 14, 130, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (76, '', 'acc_travel_expenses_general_and_admin_expenses', NULL, NULL, 14, 132, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (77, '', 'acc_travel_expenses_selling_expense', NULL, NULL, 14, 133, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (78, '', 'acc_unapplied_cash_payment_income', NULL, NULL, 11, 91, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (79, '', 'acc_uncategorised_asset', NULL, NULL, 2, 10, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (80, '', 'acc_uncategorised_expense', NULL, NULL, 14, 124, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (81, '', 'acc_uncategorised_income', NULL, NULL, 11, 89, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (82, '', 'acc_undeposited_funds', NULL, NULL, 2, 13, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (83, '', 'acc_unrealised_loss_on_securities_net_of_tax', NULL, NULL, 12, 99, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (84, '', 'acc_utilities', NULL, NULL, 14, 135, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (85, '', 'acc_wage_expenses', NULL, NULL, 14, 126, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (86, '', 'acc_credit_card', NULL, NULL, 7, 43, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (87, '', 'acc_accounts_payable', NULL, NULL, 6, 42, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);
INSERT INTO `tblacc_accounts` (`id`, `name`, `key_name`, `number`, `parent_account`, `account_type_id`, `account_detail_type_id`, `balance`, `balance_as_of`, `description`, `default_account`, `active`, `access_token`, `account_id`, `plaid_status`, `plaid_account_name`) VALUES (88, '', 'acc_opening_balance_equity', NULL, NULL, 10, 71, NULL, NULL, NULL, 1, 1, NULL, NULL, 0, NULL);


#
# TABLE STRUCTURE FOR: tblacc_banking_rule_details
#

DROP TABLE IF EXISTS `tblacc_banking_rule_details`;

CREATE TABLE `tblacc_banking_rule_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rule_id` int(11) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `subtype` varchar(45) DEFAULT NULL,
  `text` varchar(255) DEFAULT NULL,
  `subtype_amount` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_banking_rules
#

DROP TABLE IF EXISTS `tblacc_banking_rules`;

CREATE TABLE `tblacc_banking_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `transaction` varchar(45) DEFAULT NULL,
  `following` varchar(45) DEFAULT NULL,
  `then` varchar(45) DEFAULT NULL,
  `payment_account` int(11) DEFAULT NULL,
  `deposit_to` int(11) DEFAULT NULL,
  `auto_add` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budget_details
#

DROP TABLE IF EXISTS `tblacc_budget_details`;

CREATE TABLE `tblacc_budget_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `budget_id` int(11) NOT NULL,
  `month` int(11) NOT NULL,
  `year` int(11) NOT NULL,
  `account` int(11) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_budgets
#

DROP TABLE IF EXISTS `tblacc_budgets`;

CREATE TABLE `tblacc_budgets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `year` int(11) NOT NULL,
  `name` varchar(200) DEFAULT NULL,
  `type` varchar(45) DEFAULT NULL,
  `data_source` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

INSERT INTO `tblacc_budgets` (`id`, `year`, `name`, `type`, `data_source`) VALUES (1, 2024, '2024 - Profit and Loss Accounts', 'profit_and_loss_accounts', 'create_budget_from_scratch');


#
# TABLE STRUCTURE FOR: tblacc_expense_category_mappings
#

DROP TABLE IF EXISTS `tblacc_expense_category_mappings`;

CREATE TABLE `tblacc_expense_category_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `preferred_payment_method` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_item_automatics
#

DROP TABLE IF EXISTS `tblacc_item_automatics`;

CREATE TABLE `tblacc_item_automatics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) NOT NULL,
  `inventory_asset_account` int(11) NOT NULL DEFAULT 0,
  `income_account` int(11) NOT NULL DEFAULT 0,
  `expense_account` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_journal_entries
#

DROP TABLE IF EXISTS `tblacc_journal_entries`;

CREATE TABLE `tblacc_journal_entries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `number` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `journal_date` date DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_matched_transactions
#

DROP TABLE IF EXISTS `tblacc_matched_transactions`;

CREATE TABLE `tblacc_matched_transactions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_history_id` int(11) DEFAULT NULL,
  `history_amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `rel_id` int(11) DEFAULT NULL,
  `rel_type` varchar(255) DEFAULT NULL,
  `amount` decimal(15,2) NOT NULL DEFAULT 0.00,
  `company` int(11) DEFAULT NULL,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_payment_mode_mappings
#

DROP TABLE IF EXISTS `tblacc_payment_mode_mappings`;

CREATE TABLE `tblacc_payment_mode_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `payment_mode_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_plaid_transaction_logs
#

DROP TABLE IF EXISTS `tblacc_plaid_transaction_logs`;

CREATE TABLE `tblacc_plaid_transaction_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bank_id` int(11) DEFAULT NULL,
  `last_updated` date DEFAULT NULL,
  `transaction_count` int(11) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `addedFrom` int(11) DEFAULT NULL,
  `company` int(11) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_reconciles
#

DROP TABLE IF EXISTS `tblacc_reconciles`;

CREATE TABLE `tblacc_reconciles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account` int(11) NOT NULL,
  `beginning_balance` decimal(15,2) NOT NULL,
  `ending_balance` decimal(15,2) NOT NULL,
  `ending_date` date NOT NULL,
  `expense_date` date DEFAULT NULL,
  `service_charge` decimal(15,2) DEFAULT NULL,
  `expense_account` int(11) DEFAULT NULL,
  `income_date` date DEFAULT NULL,
  `interest_earned` decimal(15,2) DEFAULT NULL,
  `income_account` int(11) DEFAULT NULL,
  `finish` int(11) NOT NULL DEFAULT 0,
  `opening_balance` int(11) NOT NULL DEFAULT 0,
  `debits_for_period` decimal(15,2) DEFAULT NULL,
  `credits_for_period` decimal(15,2) DEFAULT NULL,
  `dateadded` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_tax_mappings
#

DROP TABLE IF EXISTS `tblacc_tax_mappings`;

CREATE TABLE `tblacc_tax_mappings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tax_id` int(11) NOT NULL,
  `payment_account` int(11) NOT NULL DEFAULT 0,
  `deposit_to` int(11) NOT NULL DEFAULT 0,
  `expense_payment_account` int(11) NOT NULL DEFAULT 0,
  `expense_deposit_to` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transaction_bankings
#

DROP TABLE IF EXISTS `tblacc_transaction_bankings`;

CREATE TABLE `tblacc_transaction_bankings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `withdrawals` decimal(15,2) NOT NULL DEFAULT 0.00,
  `deposits` decimal(15,2) NOT NULL DEFAULT 0.00,
  `payee` varchar(255) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  `transaction_id` varchar(150) DEFAULT NULL,
  `bank_id` int(11) DEFAULT NULL,
  `status` tinyint(5) NOT NULL DEFAULT 0 COMMENT '1=>posted, 2=>pending',
  `matched` int(11) NOT NULL DEFAULT 0,
  `reconcile` int(11) NOT NULL DEFAULT 0,
  `adjusted` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblacc_transfers
#

DROP TABLE IF EXISTS `tblacc_transfers`;

CREATE TABLE `tblacc_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_funds_from` int(11) NOT NULL,
  `transfer_funds_to` int(11) NOT NULL,
  `transfer_amount` decimal(15,2) DEFAULT NULL,
  `date` varchar(45) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `datecreated` datetime DEFAULT NULL,
  `addedfrom` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning
#

DROP TABLE IF EXISTS `tblaccount_planning`;

CREATE TABLE `tblaccount_planning` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `client_id` int(11) NOT NULL,
  `vision` varchar(255) DEFAULT NULL,
  `mission` varchar(255) DEFAULT NULL,
  `lead_generation` varchar(45) DEFAULT NULL,
  `current_service_know_pmax` varchar(45) DEFAULT NULL,
  `current_service_facebook` varchar(45) DEFAULT NULL,
  `current_service_sem` varchar(45) DEFAULT NULL,
  `objectives` varchar(255) DEFAULT NULL,
  `threat` varchar(255) DEFAULT NULL,
  `opportunity` varchar(255) DEFAULT NULL,
  `criteria_to_success` varchar(255) DEFAULT NULL,
  `constraints` varchar(255) DEFAULT NULL,
  `data_tree` longtext DEFAULT NULL,
  `latest_update` date DEFAULT NULL,
  `new_update` date DEFAULT NULL,
  `product` varchar(255) DEFAULT NULL,
  `sale_channel_online` varchar(255) DEFAULT NULL,
  `sale_channel_offline` varchar(255) DEFAULT NULL,
  `revenue_next_year` varchar(255) DEFAULT NULL,
  `wallet_share` varchar(255) DEFAULT NULL,
  `client_status` varchar(255) DEFAULT NULL,
  `bcg_model` varchar(255) DEFAULT NULL,
  `margin` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_current_service
#

DROP TABLE IF EXISTS `tblaccount_planning_current_service`;

CREATE TABLE `tblaccount_planning_current_service` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_financial
#

DROP TABLE IF EXISTS `tblaccount_planning_financial`;

CREATE TABLE `tblaccount_planning_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `year` varchar(45) DEFAULT NULL,
  `revenue` varchar(255) DEFAULT NULL,
  `sales_spent` varchar(255) DEFAULT NULL,
  `traffic` varchar(255) DEFAULT NULL,
  `loss` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_items
#

DROP TABLE IF EXISTS `tblaccount_planning_items`;

CREATE TABLE `tblaccount_planning_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `objective_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_marketing_activities
#

DROP TABLE IF EXISTS `tblaccount_planning_marketing_activities`;

CREATE TABLE `tblaccount_planning_marketing_activities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `item` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_objective
#

DROP TABLE IF EXISTS `tblaccount_planning_objective`;

CREATE TABLE `tblaccount_planning_objective` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `datecreated` date DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_service_ability_offering
#

DROP TABLE IF EXISTS `tblaccount_planning_service_ability_offering`;

CREATE TABLE `tblaccount_planning_service_ability_offering` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `service` varchar(255) DEFAULT NULL,
  `potential` varchar(255) DEFAULT NULL,
  `scale` varchar(255) DEFAULT NULL,
  `convert` varchar(255) DEFAULT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_task
#

DROP TABLE IF EXISTS `tblaccount_planning_task`;

CREATE TABLE `tblaccount_planning_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `items_id` int(11) NOT NULL,
  `account_planning_id` int(11) DEFAULT NULL,
  `action_needed` varchar(255) NOT NULL,
  `prioritization` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `deadline` date DEFAULT NULL,
  `status` varchar(255) DEFAULT NULL,
  `objective` varchar(255) DEFAULT NULL,
  `item` varchar(255) DEFAULT NULL,
  `convert_to_task` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblaccount_planning_team
#

DROP TABLE IF EXISTS `tblaccount_planning_team`;

CREATE TABLE `tblaccount_planning_team` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `account_planning_id` int(11) NOT NULL,
  `rel_id` varchar(45) NOT NULL,
  `rel_type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

#
# TABLE STRUCTURE FOR: tblactivity_log
#

DROP TABLE IF EXISTS `tblactivity_log`;

CREATE TABLE `tblactivity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `description` longtext NOT NULL,
  `date` datetime NOT NULL,
  `staffid` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `staffid` (`staffid`)
) ENGINE=InnoDB AUTO_INCREMENT=294855 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 04:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:32:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 05:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270176, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270177, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270178, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270179, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 07:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:19:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 08:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 09:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 10:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270313, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270314, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 11:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 12:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 14:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 15:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 15:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 15:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 16:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 17:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270560, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270561, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270562, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 18:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 20:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270637, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-05 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270639, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270640, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:04:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270641, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:31:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 22:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:24:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270723, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270724, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270725, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-05 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-05 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-05 23:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270740, 'Database Backup [database_backup_2025-05-06-00-02-04-v3-1-6.zip]', '2025-05-06 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 01:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 03:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 04:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:12:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 06:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 07:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (270999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271015, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271016, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271017, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271018, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 10:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 10:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 10:56:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:29:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:51:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 11:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:14:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:30:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 12:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271183, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271184, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:31:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:53:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 13:58:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 14:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:28:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271266, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271267, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271268, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271269, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271270, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271271, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271272, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271273, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271274, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 15:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271275, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271276, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271277, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271278, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271279, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271280, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271281, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271282, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271283, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271284, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271285, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271286, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271287, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271288, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271289, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271290, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271291, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271292, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271293, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271294, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271295, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271296, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271297, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271298, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271299, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271300, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271301, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271302, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271303, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271304, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271305, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271306, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271307, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 16:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271308, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271309, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271310, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271311, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271312, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271313, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271314, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271315, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271316, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271317, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271318, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271319, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271320, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271321, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271323, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271324, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271325, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271328, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271329, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271330, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271331, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271332, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271333, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271334, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271335, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271336, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271337, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271338, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271339, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271340, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271344, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271345, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271346, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271347, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271348, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271349, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271350, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271351, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271352, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271353, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271354, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271355, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271356, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271357, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271358, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271359, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271360, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271361, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271362, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271363, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271364, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271365, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271366, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271367, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271368, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271369, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271370, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271371, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271372, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271373, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:02:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 19:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 20:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 21:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 22:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-06 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-06 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-06 23:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271551, 'Database Backup [database_backup_2025-05-07-00-00-05-v3-1-6.zip]', '2025-05-07 00:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271552, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271553, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271554, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271555, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271556, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271557, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271558, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271559, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271560, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271561, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271562, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271563, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271564, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271565, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271566, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271567, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271568, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271569, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271570, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271571, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271572, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271573, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271574, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271575, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271576, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271577, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271578, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271579, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271580, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271581, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 00:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271582, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271583, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271584, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271585, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271586, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271587, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271588, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271589, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271590, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271591, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271592, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271593, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271594, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271595, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271596, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271597, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271598, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271599, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271600, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271601, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271602, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:33:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271603, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271604, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271605, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271606, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271607, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271608, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271609, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271610, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271611, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271612, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 01:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271613, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 01:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271614, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 01:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271615, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271616, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271617, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:00:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271618, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271619, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271620, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271621, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271626, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271627, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271628, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271629, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271630, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271631, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271632, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271633, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271634, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271635, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271636, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271637, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271638, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271642, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271643, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271644, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271645, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271646, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271647, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271648, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271649, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271650, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 02:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271651, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271652, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271653, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271654, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271655, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271656, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271657, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271658, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271659, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271660, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271661, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271662, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271663, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271664, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271665, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271666, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271667, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271668, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271669, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271670, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271671, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271672, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271673, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271674, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271675, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271676, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271677, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271678, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271679, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271680, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271681, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271682, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271683, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 03:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271684, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271685, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271686, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271687, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271688, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271689, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271690, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271691, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271692, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271693, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271694, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271695, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271696, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271697, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271698, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271699, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271700, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271701, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271702, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271703, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271704, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271705, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271706, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271707, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271708, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271709, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271710, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271711, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271712, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271713, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271714, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271715, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271716, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 04:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271717, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271718, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271719, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271720, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271726, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271727, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271728, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271729, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271730, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271731, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271732, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271733, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271734, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271735, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271736, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271737, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271738, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271739, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271740, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271741, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271742, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271743, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271744, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271745, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271746, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271747, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271748, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271749, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271750, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271751, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271752, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271753, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271754, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271755, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271756, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271757, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271758, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271759, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271760, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271761, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271762, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271763, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271764, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271765, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271766, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271767, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271768, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271769, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271770, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271771, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271772, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271773, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271774, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271775, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271776, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271777, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271778, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271779, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271780, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271781, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271782, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271783, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271784, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271785, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271786, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271787, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271788, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271789, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271790, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271791, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:17:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271792, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271793, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271794, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271795, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271796, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271797, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271798, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271799, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271800, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271801, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271802, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271803, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271804, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271805, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271806, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271807, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271808, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271809, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271810, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271811, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271812, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 07:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271813, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271814, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271815, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271816, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271817, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271818, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271819, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271820, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271821, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271822, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271823, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271824, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271825, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271826, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271827, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271828, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271829, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271830, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:28:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271831, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271832, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271833, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271834, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271835, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271836, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271837, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271838, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271839, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271840, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271841, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271842, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:50:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271843, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 08:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271844, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 08:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271845, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 08:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271846, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271847, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271848, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271849, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271850, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271851, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271852, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271853, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271854, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271855, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271856, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271857, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271858, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271859, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271860, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271861, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271862, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271863, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271864, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271865, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271866, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:34:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271867, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271868, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271869, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271872, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271873, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271876, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271877, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271878, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 09:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271879, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271880, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271881, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271882, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271883, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271884, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271885, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271886, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271887, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271888, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271889, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271890, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271891, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271892, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271893, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271896, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271897, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271898, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271899, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271900, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:40:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271903, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271904, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271905, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271906, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271907, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271908, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271909, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271910, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271911, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 10:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271912, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271913, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271914, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271915, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271916, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271917, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271918, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271919, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271920, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271921, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271922, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271923, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271924, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271925, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271926, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271927, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271928, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271929, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271930, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271931, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271932, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271933, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271934, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271935, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271936, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271937, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271938, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271939, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271940, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271941, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 11:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271942, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271943, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271944, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:00:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271945, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271946, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271947, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271951, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271952, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271953, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271954, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271955, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271956, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271957, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271958, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271959, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271960, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271961, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271962, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271963, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271964, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271965, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271966, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271967, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271968, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271969, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271970, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271971, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271972, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271973, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271974, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 12:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271975, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271976, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271977, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271978, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271979, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271980, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271981, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271982, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271983, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:07:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271984, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271985, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271986, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271987, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271988, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271989, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271990, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271991, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271992, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:23:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271993, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271994, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271995, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271996, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271997, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271998, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (271999, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272000, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272001, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272002, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272003, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272004, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272005, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272006, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272007, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272008, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272009, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272010, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 13:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272011, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272012, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272013, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272014, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272015, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272016, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272019, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:07:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272020, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272021, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272022, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272025, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272026, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272027, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272028, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272029, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272030, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272031, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272032, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272033, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272034, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272035, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272036, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272037, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272038, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272039, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272040, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272041, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272042, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272043, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272044, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272045, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272046, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272047, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272048, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272049, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272050, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272051, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272052, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272053, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272054, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272055, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272056, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272057, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272058, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272059, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272060, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272061, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272062, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272063, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272064, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272065, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272066, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272067, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272068, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272069, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272070, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272071, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272072, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272073, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272074, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272075, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272076, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272077, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272078, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272079, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272080, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272081, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272082, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272083, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272084, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272085, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 15:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272086, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272087, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272088, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272089, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272090, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272091, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272092, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272093, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272094, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272095, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272096, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272097, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:20:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:31:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 16:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 17:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 17:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 17:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 17:15:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 17:15:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 17:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 17:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 17:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272144, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272145, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 17:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 17:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 17:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 17:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 17:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 17:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 18:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 18:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 18:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 18:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 18:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 18:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 18:33:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 18:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 18:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 18:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 18:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 18:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 19:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 19:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 19:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272206, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272207, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272208, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 19:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272209, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272210, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272211, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272212, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272213, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272214, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 19:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272215, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272216, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272217, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 19:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272218, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272219, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272220, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 19:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272221, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272222, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272223, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 19:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272224, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272225, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272226, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 19:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272227, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272228, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272229, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 19:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272230, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272231, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272232, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 19:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272233, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272234, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272235, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 20:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272236, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272237, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272238, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 20:08:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272239, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272240, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272241, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 20:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272242, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272243, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272244, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 20:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272247, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 20:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272248, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 20:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272249, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 20:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272250, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 20:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272251, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272252, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272253, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 20:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272254, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272255, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272256, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272257, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272258, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272259, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272260, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272261, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272262, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 20:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272263, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272264, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272265, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272266, 'Email Sent To [Email: saylesstt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-07 21:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272267, 'Email Sent To [Email: jonesy.tt.ss@gmail.com, Template: Invoice Overdue Notice]', '2025-05-07 21:04:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 21:04:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 21:04:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 21:04:17', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 21:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 21:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 21:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 21:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 21:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 21:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 21:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 21:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 22:05:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 22:10:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 22:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 22:21:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 22:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 22:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 22:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 22:44:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272326, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272327, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272328, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272329, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 22:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 22:55:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 23:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 23:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 23:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272341, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272342, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272343, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 23:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 23:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 23:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 23:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 23:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 23:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 23:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 23:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 23:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-07 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-07 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-07 23:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 00:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272373, 'Database Backup [database_backup_2025-05-08-00-03-04-v3-1-6.zip]', '2025-05-08 00:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272374, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272375, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272376, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 00:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272377, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272378, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272379, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 00:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272380, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272381, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272382, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 00:20:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272383, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272384, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272385, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 00:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272386, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 00:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272387, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 00:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272388, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 00:30:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272389, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272390, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272391, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 00:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272392, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272393, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272394, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 00:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272395, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272396, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272397, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 00:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272398, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272399, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272400, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 00:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272403, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 00:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272404, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 01:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272405, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 01:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272406, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 01:03:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272407, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272408, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272409, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 01:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272410, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272411, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272412, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 01:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272413, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272414, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272415, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 01:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272416, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272417, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272418, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 01:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272419, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272420, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272421, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 01:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272422, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272423, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272424, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 01:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272425, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272426, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272427, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 01:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272428, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272429, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 01:48:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272430, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 01:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272431, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272432, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272433, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 01:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272434, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272435, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272436, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 01:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272437, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272438, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272439, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 02:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272440, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272441, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272442, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 02:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272443, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272444, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272445, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 02:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272446, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272447, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272448, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 02:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272449, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272450, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272451, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 02:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272452, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272453, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272454, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 02:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272455, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272456, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272457, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 02:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272458, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272459, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272460, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 02:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272461, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272462, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272463, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 02:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272464, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272465, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272466, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 02:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272467, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272468, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272469, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 03:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272470, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272471, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272472, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 03:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272473, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272474, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272475, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 03:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272476, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272477, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272478, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 03:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272479, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272480, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272481, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 03:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272482, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272483, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272484, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 03:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272485, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272486, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272487, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 03:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272488, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272489, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272490, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 03:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272491, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272492, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272493, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 03:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272494, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272495, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272496, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 03:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272497, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272498, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272499, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 03:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272500, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272501, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272502, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 04:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272503, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272504, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272505, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 04:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272506, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272507, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272508, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 04:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272509, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272510, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272511, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 04:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272512, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272513, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272514, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272515, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272516, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272517, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 04:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272518, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272519, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272520, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 04:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272521, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272522, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272523, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 04:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272524, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272525, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 04:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272526, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 04:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272527, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272528, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272529, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 04:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272530, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272531, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272532, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 05:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272533, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272534, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272535, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 05:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272536, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272537, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272538, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 05:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272539, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272540, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272541, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 05:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272542, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272543, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272544, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 05:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272545, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272546, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272547, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 05:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272548, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272549, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272550, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272551, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272552, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272553, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272554, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272555, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272556, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272557, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272558, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272559, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 05:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 05:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272563, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 06:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272564, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 06:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272565, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 06:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272566, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272567, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272568, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 06:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272569, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272570, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272571, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 06:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272572, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272573, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272574, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 06:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272575, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272576, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272577, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 06:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272578, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272579, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272580, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 06:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272581, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272582, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272583, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 06:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272584, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272585, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272586, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 06:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272587, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272588, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272589, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 06:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272590, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272591, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272592, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 06:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272593, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272594, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 06:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272595, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272596, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272597, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272598, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 07:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272599, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272600, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272601, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 07:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272602, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272603, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272604, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 07:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272605, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272606, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272607, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272608, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272609, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272610, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 07:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272611, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272612, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272613, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 07:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272614, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272615, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272616, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272617, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272618, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272619, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 07:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272620, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272621, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272622, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 07:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272623, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272624, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272625, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 07:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272626, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272627, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272628, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 07:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272629, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272630, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272631, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 07:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272632, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272633, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272634, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 07:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272635, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272636, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272637, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 08:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272638, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272639, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272640, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272641, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272642, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272643, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 08:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272644, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272645, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272646, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 08:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272647, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272648, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272649, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 08:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272650, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272651, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 08:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272652, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 08:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272653, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272654, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272655, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 08:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272656, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272657, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 08:38:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272658, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 08:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272659, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272660, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272661, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 08:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272662, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272663, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272664, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 08:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272665, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272666, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272667, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 08:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272668, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272669, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272670, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 08:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272671, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272672, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272673, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 09:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272674, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272675, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272676, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 09:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272677, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272678, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272679, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 09:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272680, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272681, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272682, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 09:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272683, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272684, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272685, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 09:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272686, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272687, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272688, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 09:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272689, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272690, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272691, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 09:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272692, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272693, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272694, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 09:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272695, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272696, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272697, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 09:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272698, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272699, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272700, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 09:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272701, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 09:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272702, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 09:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272703, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 09:59:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272704, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272705, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272706, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 10:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272707, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272708, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272709, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 10:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272710, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272711, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272712, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 10:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272713, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272714, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272715, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 10:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272716, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272717, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272718, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272721, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 10:26:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272722, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272723, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272724, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272725, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272726, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 10:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272727, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 10:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272728, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272729, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272730, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 10:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272731, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272732, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272733, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 10:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272734, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272735, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272736, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 10:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272737, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272738, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272739, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 10:55:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272740, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272741, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272742, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 11:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272743, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272744, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272745, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 11:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272746, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272747, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272748, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 11:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272749, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272750, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272751, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 11:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272752, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272753, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272754, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 11:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272755, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272756, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272757, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 11:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272758, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 11:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272759, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272760, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 11:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272761, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272762, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272763, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 11:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272764, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272765, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272766, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 11:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272767, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272768, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272769, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 11:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272770, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272771, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272772, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 11:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272773, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272774, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272775, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 12:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272776, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272777, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272778, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 12:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272779, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272780, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272781, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 12:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272782, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272783, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272784, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 12:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272785, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272786, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272787, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 12:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272788, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272789, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272790, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 12:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272791, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 12:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272792, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 12:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272793, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 12:35:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272794, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272795, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272796, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 12:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272797, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272798, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272799, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 12:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272800, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272801, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272802, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 12:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272803, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272804, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272805, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 12:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272806, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272807, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272808, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 13:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272809, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272810, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272811, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 13:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272812, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272813, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272814, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 13:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272815, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272816, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272817, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 13:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272818, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272819, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272820, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 13:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272821, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272822, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272823, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 13:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272824, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272825, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272826, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 13:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272827, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272828, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272829, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 13:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272830, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272831, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272832, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 13:46:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272833, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272834, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272835, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 13:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272836, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272837, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272838, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 13:57:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272839, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272840, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272841, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 14:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272842, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272843, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272844, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 14:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272845, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272846, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272847, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 14:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272848, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272849, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272850, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 14:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272851, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272852, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272853, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272854, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272855, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272856, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 14:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272857, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272858, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272859, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 14:37:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272860, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272861, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272862, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 14:42:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272863, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 14:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272864, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 14:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272865, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 14:47:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272866, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272867, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272868, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 14:53:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272869, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272870, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272871, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272872, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272873, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272874, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 14:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272875, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272876, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272877, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272878, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272879, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272880, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 15:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272881, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 15:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272882, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 15:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272883, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 15:09:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272884, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272885, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272886, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 15:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272887, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272888, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272889, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 15:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272890, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272891, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272892, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 15:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272893, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272894, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272895, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272898, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 15:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272901, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 15:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272902, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272903, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272904, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272905, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272906, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272907, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 15:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272908, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272909, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272910, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272911, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272912, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272913, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 15:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272914, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 15:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272915, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 15:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272916, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 15:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272917, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272918, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272919, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 16:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272920, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 16:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272921, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 16:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272922, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 16:05:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272923, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272924, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272925, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272926, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272927, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272928, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 16:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272929, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 16:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272930, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 16:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272931, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 16:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272932, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272933, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272934, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 16:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272935, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 16:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272936, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 16:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272937, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 16:27:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272938, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272939, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272940, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 16:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272941, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272942, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272943, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 16:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272944, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 16:45:26', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272945, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 16:45:27', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272946, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 16:45:36', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272947, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 16:45:43', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272948, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 16:45:43', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272949, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 16:45:43', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272950, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 16:45:43', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272951, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 16:45:43', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272952, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 16:45:45', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272953, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272954, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272955, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 16:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272956, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272957, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272958, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272959, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272960, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272961, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 17:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272962, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272963, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272964, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 17:06:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272965, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 17:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272966, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272967, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272968, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272969, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272970, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 17:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272971, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272972, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272973, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 17:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272974, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272975, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272976, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 17:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272977, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272978, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272979, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 17:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272980, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272981, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272982, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 17:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272983, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272984, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272985, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272986, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272987, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272988, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272989, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272990, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272991, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272992, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272993, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272994, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272995, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272996, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272997, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272998, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (272999, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273000, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 18:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273001, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273002, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273003, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273004, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273005, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273006, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273007, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273008, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273009, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 18:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273010, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273011, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273012, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 18:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273013, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273014, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273015, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 18:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 18:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 18:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273023, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273024, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273025, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273026, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 19:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 19:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 19:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 19:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 19:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 19:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 19:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 19:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 20:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 20:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 20:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 20:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 20:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 20:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273097, 'Email Sent To [Email: sofiecaesartt@gmail.com, Template: Invoice Overdue Notice]', '2025-05-08 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273098, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273099, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273100, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 21:04:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273101, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273102, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273103, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 21:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273104, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273105, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273106, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 21:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273107, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273108, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273109, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 21:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273110, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273111, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273112, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 21:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273113, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273114, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273115, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273116, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273117, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273118, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273119, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273120, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273121, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273122, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273123, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273124, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273125, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273126, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273127, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273128, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273129, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273130, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 22:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273131, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 22:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273132, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 22:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273133, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 22:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273134, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273135, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273136, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 22:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273137, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273138, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273139, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 22:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273140, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273141, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273142, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 22:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273143, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273144, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273145, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 22:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273146, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273147, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273148, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 22:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273149, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273150, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273151, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 22:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273152, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 22:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273153, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 22:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273154, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 22:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273155, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273156, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273157, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273158, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273159, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273160, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 22:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273161, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273162, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273163, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 22:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273164, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273165, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273166, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 22:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273167, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273168, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273169, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 23:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273170, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273171, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273172, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 23:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273173, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273174, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273175, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 23:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273178, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 23:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273179, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273180, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273181, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 23:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273182, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273183, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273184, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 23:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273185, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273186, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273187, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 23:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273188, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 23:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273189, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 23:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273190, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 23:42:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273191, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273192, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273193, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 23:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273194, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273195, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273196, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 23:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273197, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-08 23:59:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273198, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-08 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273199, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-08 23:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273200, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273201, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273202, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273203, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273204, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273205, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 00:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273206, 'Database Backup [database_backup_2025-05-09-00-04-10-v3-1-6.zip]', '2025-05-09 00:04:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273207, 'Database Backup [database_backup_2025-05-09-00-04-10-v3-1-6-1.zip]', '2025-05-09 00:04:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 00:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 00:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 00:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 00:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 00:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 00:31:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 00:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 00:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 00:36:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 00:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 00:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 00:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 00:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 01:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 01:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273245, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273246, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 01:14:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273247, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273248, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 01:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 01:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 01:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 01:25:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 01:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 01:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 01:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 01:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 01:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 01:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 01:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 01:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 01:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 02:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 02:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 02:25:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 02:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 02:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 02:52:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 02:58:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 03:03:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 03:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 03:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 03:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 03:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 03:30:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 03:36:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 03:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 03:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 03:53:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 03:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:04:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:15:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 04:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 04:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 04:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:39:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 05:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273401, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273402, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273403, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273404, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:23:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 06:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:18:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:23:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273492, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273493, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273494, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:50:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 08:56:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:01:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273515, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273516, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:22:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273517, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273518, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273519, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273520, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273521, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273522, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273523, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273524, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273525, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273526, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273527, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273528, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273529, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273530, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273531, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273532, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273533, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273534, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 09:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273535, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273536, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273537, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273538, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273539, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273540, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273541, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273542, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273543, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273544, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273545, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273546, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:16:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273547, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273548, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273549, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273550, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273551, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273552, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273553, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273554, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273555, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273556, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273557, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273558, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273559, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273560, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273561, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273562, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273563, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273564, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273565, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273566, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273567, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273568, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 10:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273569, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 10:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273570, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 10:54:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273571, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273572, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273573, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273574, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273575, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273576, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273577, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273578, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273579, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273580, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273581, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273582, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273583, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273584, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273585, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:22:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273586, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273587, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273588, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273589, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273590, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273591, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273592, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273593, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273594, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:37:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273595, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273596, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273597, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:43:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273598, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273599, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273600, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273601, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273602, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273603, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273604, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273605, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273606, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273607, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273608, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273609, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273610, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273611, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273612, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273613, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273614, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273615, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273616, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273617, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273618, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273619, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273620, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273621, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273622, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273623, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273624, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273625, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273626, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273627, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273628, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273629, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273630, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:43:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273631, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273632, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273633, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273634, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273635, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273636, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 12:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273637, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273638, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273639, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273640, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273641, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273642, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273643, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273644, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273645, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273646, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273647, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273648, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273649, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273650, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273651, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273652, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273653, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273654, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273655, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273656, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273657, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273658, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273659, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273660, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273661, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273662, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273663, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273664, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273665, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273666, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:48:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273667, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273668, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273669, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273670, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273671, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273672, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 13:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273673, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273674, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273675, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273676, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273677, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273678, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273679, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273680, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273681, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:15:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273682, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273683, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273684, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273685, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273686, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273687, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273688, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273689, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273690, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273691, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273692, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273693, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273694, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273695, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273696, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273697, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273698, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273699, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273700, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273701, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273702, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273703, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273704, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273705, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 14:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273706, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273707, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273708, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273709, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273710, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273711, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:05:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273712, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273713, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273714, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:10:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273715, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273716, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:15:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273717, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:15:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273718, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273719, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273720, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273721, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273722, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273723, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:21:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273724, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273725, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273726, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273727, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273728, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273729, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273730, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273731, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273732, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273733, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273734, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273735, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273736, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273737, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273738, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273739, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 15:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273740, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 15:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273741, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 15:55:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273742, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273743, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273744, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:00:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273745, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273746, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273747, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273748, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273749, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273750, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273751, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273752, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273753, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:17:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273754, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273755, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273756, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273757, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273758, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273759, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273760, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273761, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273762, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273763, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273764, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273765, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273766, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273767, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273768, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:44:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273769, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273770, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273771, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273772, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273773, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273774, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 16:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273775, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273776, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273777, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:01:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273778, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273779, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273780, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273781, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273782, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273783, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273784, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273785, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273786, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273787, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273788, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273789, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273790, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273791, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273792, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273793, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273794, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273795, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273796, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273797, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273798, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273799, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273800, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273801, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273802, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273803, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273804, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:45:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273805, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273806, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273807, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273808, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273809, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273810, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 17:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273811, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273812, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273813, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273814, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273815, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:07:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273816, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273817, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273818, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273819, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:12:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273820, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273821, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273822, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273823, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273824, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273825, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:23:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273826, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273827, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273828, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:29:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273829, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273830, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273831, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:34:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273832, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273833, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273834, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:40:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273835, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273836, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273837, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273838, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273839, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273840, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:51:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273841, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273842, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273843, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 18:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273844, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273845, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273846, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273847, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273848, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273849, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:08:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273850, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273851, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273852, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273853, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273854, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273855, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:18:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273856, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273857, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273858, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273859, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273860, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273861, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273862, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273863, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273864, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273865, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273866, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273867, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273868, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273869, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273870, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273871, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273872, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273873, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273874, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273875, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273876, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:52:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273877, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273878, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273879, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 19:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273880, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273881, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:03:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273882, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:03:11', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273883, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273884, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273885, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273886, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273887, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273888, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273889, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273890, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273891, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273892, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273893, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273894, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273895, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273896, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273897, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273898, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273899, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273900, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273901, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273902, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273903, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273904, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273905, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273906, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:42:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273907, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273908, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273909, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:48:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273910, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:54:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273911, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273912, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273913, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273914, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273915, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 20:59:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273916, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273917, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273918, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:04:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273919, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273920, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273921, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:10:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273922, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273923, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273924, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273925, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273926, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273927, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273928, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273929, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273930, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273931, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273932, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273933, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273934, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273935, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273936, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273937, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273938, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273939, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273940, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273941, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273942, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273943, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273944, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273945, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 21:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273946, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273947, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273948, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:00:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273949, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273950, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273951, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273952, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273953, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273954, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273955, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273956, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273957, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273958, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273959, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273960, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273961, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273962, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273963, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:28:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273964, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273965, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273966, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273967, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273968, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273969, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:39:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273970, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273971, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273972, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273973, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273974, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273975, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273976, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273977, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273978, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 22:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273979, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273980, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273981, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273982, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273983, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273984, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273985, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273986, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273987, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:11:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273988, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273989, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273990, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:17:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273991, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273992, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273993, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:22:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273994, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273995, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273996, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273997, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273998, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (273999, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:34:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274000, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274001, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274002, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:40:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274003, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274004, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274005, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:45:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274006, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274007, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274008, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:50:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274009, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274010, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274011, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-09 23:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274012, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274013, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274014, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274015, 'Database Backup [database_backup_2025-05-10-00-02-04-v3-1-6.zip]', '2025-05-10 00:02:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274016, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274017, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274018, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274019, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274020, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274021, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:13:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274022, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274023, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274024, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274025, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274026, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274027, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274028, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274029, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274030, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274031, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274032, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274033, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274034, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274035, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274036, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274037, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274038, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274039, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:45:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274040, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274041, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274042, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274043, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274044, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274045, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 00:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274046, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274047, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274048, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:01:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274049, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274050, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274051, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:07:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274052, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274053, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274054, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274055, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274056, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274057, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:18:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274058, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274059, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274060, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274061, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274062, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274063, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:30:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274064, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274065, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274066, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:35:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274067, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274068, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274069, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274070, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274071, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274072, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274073, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274074, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274075, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:52:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274076, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274077, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274078, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 01:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274079, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274080, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274081, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274082, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274083, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274084, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274085, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274086, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274087, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274088, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274089, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274090, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:19:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274091, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274092, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274093, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:25:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274094, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274095, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274096, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274097, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274098, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274099, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274100, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274101, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274102, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:41:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274103, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274104, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274105, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:47:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274106, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274107, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274108, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274109, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274110, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274111, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 02:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274112, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274113, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274114, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274115, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274116, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274117, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:09:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274118, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274119, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274120, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:15:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274121, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274122, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274123, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:20:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274124, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274125, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274126, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:26:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274127, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274128, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274129, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:31:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274130, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274131, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274132, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:36:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274133, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274134, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274135, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:42:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274136, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274137, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274138, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:47:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274139, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274140, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274141, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:53:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274142, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274143, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274144, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 03:58:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274145, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274146, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274147, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:04:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274148, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274149, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274150, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:09:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274151, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274152, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274153, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274154, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274155, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274156, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:14:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274157, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274158, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274159, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:20:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274160, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274161, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274162, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:25:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274163, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274164, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274165, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:30:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274166, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274167, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274168, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:36:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274169, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274170, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274171, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274172, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274173, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274174, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274175, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274176, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274177, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274178, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274179, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274180, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274181, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274182, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274183, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 04:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274184, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274185, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274186, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:03:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274187, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274188, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274189, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:09:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274190, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274191, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274192, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:14:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274193, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274194, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274195, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:20:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274196, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274197, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274198, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:26:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274199, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274200, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274201, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274202, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274203, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274204, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274205, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274206, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274207, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274208, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274209, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274210, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:49:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274211, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274212, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274213, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 05:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274214, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274215, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274216, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:00:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274217, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274218, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274219, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274220, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274221, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274222, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:11:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274223, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274224, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274225, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274226, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274227, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274228, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274229, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274230, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274231, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:27:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274232, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274233, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274234, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:32:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274235, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274236, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274237, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:38:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274238, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274239, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274240, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:43:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274241, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274242, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274243, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:49:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274244, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274245, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274246, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274247, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274248, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274249, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 06:54:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274250, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274251, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274252, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:00:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274253, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274254, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274255, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:06:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274256, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274257, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274258, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:11:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274259, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274260, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274261, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:16:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274262, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274263, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274264, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274265, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274266, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274267, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:28:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274268, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274269, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274270, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:33:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274271, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274272, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274273, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274274, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274275, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274276, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274277, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274278, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274279, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274280, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274281, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274282, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 07:56:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274283, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274284, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274285, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274286, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274287, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274288, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274289, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274290, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274291, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274292, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274293, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274294, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274295, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274296, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274297, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274298, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274299, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274300, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274301, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274302, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274303, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274304, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274305, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274306, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:40:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274307, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274308, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274309, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:45:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274310, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274311, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274312, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:51:01', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274313, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274314, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274315, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 08:56:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274316, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274317, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274318, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:02:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274319, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274320, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274321, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:07:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274322, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274323, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274324, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:13:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274325, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274326, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274327, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:18:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274328, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274329, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274330, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:24:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274331, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274332, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274333, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:29:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274334, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274335, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274336, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:35:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274337, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274338, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274339, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274340, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274341, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274342, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:40:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274343, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274344, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274345, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:46:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274346, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274347, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274348, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:51:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274349, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274350, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274351, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 09:57:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274352, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274353, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274354, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:02:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274355, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274356, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274357, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:08:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274358, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274359, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274360, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:13:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274361, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274362, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274363, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:19:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274364, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274365, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274366, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:24:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274367, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274368, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274369, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:30:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274370, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274371, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274372, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:35:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274373, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274374, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274375, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:41:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274376, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274377, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274378, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:46:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274379, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274380, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274381, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:52:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274382, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274383, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274384, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 10:58:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274385, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274386, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274387, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:04:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274388, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274389, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274390, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:10:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274391, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274392, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274393, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:15:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274394, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274395, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274396, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:21:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274397, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274398, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274399, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:26:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274400, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274401, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274402, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:32:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274403, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274404, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274405, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:37:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274406, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274407, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274408, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:43:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274409, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274410, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274411, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:48:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274412, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274413, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274414, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:54:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274415, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274416, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274417, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274418, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274419, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274420, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 11:59:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274421, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274422, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274423, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:05:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274424, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274425, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274426, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:10:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274427, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274428, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274429, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:16:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274430, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274431, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274432, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:21:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274433, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274434, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274435, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:21:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274436, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274437, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274438, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274439, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274440, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274441, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:33:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274442, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274443, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274444, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:39:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274445, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274446, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274447, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:44:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274448, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274449, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274450, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:50:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274451, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 12:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274452, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 12:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274453, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 12:55:05', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274454, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274455, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274456, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274457, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274458, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274459, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:00:09', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274460, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274461, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274462, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:06:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274463, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274464, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274465, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274466, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274467, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274468, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:11:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274469, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274470, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274471, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:16:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274472, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274473, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274474, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:22:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274475, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274476, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274477, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:27:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274478, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274479, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274480, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:32:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274481, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274482, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274483, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:38:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274484, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274485, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274486, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:44:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274487, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274488, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274489, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:49:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274490, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274491, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274492, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274493, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274494, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274495, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 13:55:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274496, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274497, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274498, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:00:06', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274499, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274500, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274501, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:06:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274502, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:12:03', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274503, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274504, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:12:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274505, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274506, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274507, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:17:04', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274508, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:23:07', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274509, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274510, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:23:08', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274511, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274512, 'Failed to connect to IMAP auto importing tickets for department support@saylesstt.com.', '2025-05-10 14:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274513, 'Failed to connect to IMAP auto importing tickets for department development@saylesstt.com.', '2025-05-10 14:23:10', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staffid`) VALUES (274514, 'Failed to connect to IMAP auto importing tickets for department billing@saylesstt.com.', '2025-05-10 14:29:02', '[CRON]');
INSERT INTO `tblactivity_log` (`id`, `description`, `date`, `staf